<?php
	require_once "Soporte.php";
	
	class DVD extends Soporte
	{
		private $idiomasDisponibles = Array();
		private $formatoPantalla;
		
		public function DVD($numero = 0, $titulo = "DVD Sense titol", $precio = 30, $idiomasDisponibles = Array("indefinits"), $formatoPantalla = "indefinit")
		{
			//Crida al constructor del pare:
			parent::Soporte($numero, $titulo, $precio);
			
			$this->setIdiomasDisponibles($idiomasDisponibles);
			$this->setFormatoPantalla($formatoPantalla);
		}
		
		public function setIdiomasDisponibles($idiomasDisponibles)
		{
			if (is_array($idiomasDisponibles))
			{
				$this->idiomasDisponibles = $idiomasDisponibles;
			}
		}
		
		public function getIdiomasDisponibles()
		{
			return $this->idiomasDisponibles;
		}
		
		public function setFormatoPantalla($formatoPantalla)
		{
			$this->formatoPantalla = $formatoPantalla;
		}
		
		public function getFormatoPantalla()
		{
			return $this->formatoPantalla;
		}
		
		public function agafaCadena()
		{
			$cadena = parent::agafaCadena();
			
			$cadena .= " [idiomes: " . implode($this->getIdiomasDisponibles(), ",") . "]";
			$cadena .= " [Format pantalla: " . $this->getFormatoPantalla() . "]";
			
			return $cadena;
		}
	}
?>