<?php
	require_once "Soporte.php";
	require_once "DVD.php";
	//Nota: faltaria l'include de Clients.php, pero no ho he implementat en l'exercici.

	class Videoclub
	{
		public $nom; //nom del negoci
		private $productes; //array de suports (Nota: faig els index numerics i no una matriu associativa, per a que els metodes shift i unshift puguin "desplaar" els elements de la matriu).
		private $nomProductes; //comptador de suports
		private $clients; //array de clients (Nota: faig els index numerics i no una matriu associativa, per a que els metodes shift i unshift puguin "desplaar" els elements de la matriu).
		private $numClients; // comptador de clients

		//Constructor (tambe pot ser __construct):
		public function Videoclub($nom = "Sense nom", $productes = Array(), $clients = Array())
		{
			$this->setNom($nom);
			$this->setProductes($productes);
			$this->setClients($clients);
		}
		
		public function setNom($nom) //No fa falta perque es public, pero per si es volgues ficar en privat ho faig.
		{
			$this->nom = $nom;
		}
		
		public function getNom() //No fa falta perque es public, pero per si es volgues ficar en privat ho faig.
		{
			return $this->nom;
		}
		
		public function setProductes($productes)
		{
			if (is_array($productes))
			{
				$this->productes = $productes;
				$this->setNumProductes(sizeof($this->getProductes()));
			}
		}
		
		public function getProductes()
		{
			return $this->productes;
		}
		
		public function setNumProductes($numProductes) //Nota: No fa falta "tallar" l'array perque faig servir shift i unshift.
		{
			if ($numProductes >= 0) //Permitim ficar 0 productes.
			{
				$this->numProductes = $numProductes;
			}
		}
		
		public function getNumProductes()
		{
			return $this->numProductes;
		}
		
		public function setClients($clients)
		{
			if (is_array($clients))
			{
				$this->clients = $clients;
				$this->setNumClients(sizeof($this->getClients()));
			}
		}
		
		public function getClients()
		{
			return $this->clients;
		}
		
		public function setNumClients($numClients) //Nota: No fa falta "tallar" l'array perque faig servir shift i unshift.
		{
			if ($numClients >= 0)
			{
				$this->numClients = $numClients;
			}
		}
		
		public function getNumClients()
		{
			return $this->numClients;
		}
		
		//Fica un producte:
		public function ficaProducte($producte)
		{
			//Si el producte no esta ja ficat, procedeix:
			if ($this->getProducte($producte->getNumero()) == NULL)
			{
				array_unshift($this->productes, $producte);
				$this->setNumProductes($this->getNumProductes() + 1);
			}
		}
		
		//Retorna un producte (consulta):
		public function getProducte($numero)
		{
			$producte = NULL;
			
			for ($x = 0; $x < $this->getNumProductes(); $x++)
			{
				$producteLoop = $this->productes[$x];
				if ($numero == $producteLoop->getNumero())
				{
					$producte = $producteLoop;
					break;
				}
			}
			
			return $producte;
		}
		
		//Elimina un producte:
		public function popProducte($numero)
		{
			//Si el producte esta ficat, procedeix:
			$producte = $this->getProducte($numero);
			if ($producte != NULL)
			{
				$this->ficaProducteEsquerra($numero);
				array_shift($this->productes);
				$this->setNumProductes($this->getNumProductes() - 1);
			}
		}
		
		//Fica un producte a l'esquerra (adalt) de la matriu, per fer-li un push:
		public function ficaProducteEsquerra($numero)
		{
			for ($x = 0; $x < $this->getNumProductes(); $x++)
			{
				$producte = $this->productes[$x];
				
				if ($numero == $producte->getNumero())
				{
					$temp = $this->productes[0];
					$this->productes[0] = $producte;
					$this->productes[$x] = $temp;
					break;
				}
			}
		}
		
		//Modifica un producte (fica un diferent en la posicio d'un existent):
		public function modificaProducte($posicio, $producte)
		{
			if ($posicio >= 0 && $posicio < $this->getNumProductes())
			{
				$this->productes[$posicio] = $producte;
			}
		}
		
		//Fica un client:
		public function ficaClient($client)
		{
			//Falta implementar, pero no era necessari per a l'exercici.
		}
		
		//Retorna un client (consulta):
		public function getClient($client)
		{
			//Falta implementar, pero no era necessari per a l'exercici.
		}
		
		//Elimina un client:
		public function popClient($client)
		{
			//Falta implementar, pero no era necessari per a l'exercici.
		}
		
		//Modifica un client (fica un diferent en la posicio d'un existent):
		public function modificaClient($numero, $client)
		{
			//Falta implementar, pero no era necessari per a l'exercici.
		}
		
		public function incloure_dvd(DVD $dvd)
		{
			//Com un DVD es tambe un Soporte, faig servir el mateix metode:
			$this->ficaProducte($dvd); //No faig casting per no perdre els metodes propis de l'objecte Client.
		}
		
		public function agafaCadenaProductes()
		{
			//$productes = $this->getProductes();
			$cadena = "";
			for ($x = 0; $x < $this->getNumProductes(); $x++)
			{
				$producte = $this->productes[$x];
				$cadena .= $producte->agafaCadena();
				$cadena .= "<br>";
			}
			return $cadena;
		}
		
		public function llistarProductes()
		{
			$cadena = $this->agafaCadenaProductes();
			if (trim($cadena) == "")
			{
				$cadena = "No hi han productes";
			}
			echo "<b>Llistat de productes:</b><br>";
			echo $cadena;
		}
		
	}
?>