<?php
	//Si no estem autoritzats a accedir a aquest script, surt:
	if (!isset($autoritzat) || isset($autoritzar) && !$autoritzat) { exit(0); }
	
	//Funcio que retorna la matriu amb les variables per post:
	function getPost()
	{
		if (isset($HTTP_POST_VARS)) { $post = $HTTP_POST_VARS; }
		else if (isset($_POST)) { $post = $_POST; }
		else { $post = Array(); } //Matriu buida.
		return $post;
	}
	
	//Funcio que retorna la matriu amb les cookies:
	function getCookies()
	{
		if (isset($HTTP_COOKIE_VARS)) { $cookies = $HTTP_COOKIE_VARS; }
		else if (isset($_COOKIE)) { $cookies = $_COOKIE; }
		else { $cookies = Array(); } //Matriu buida.
		return $cookies;
	}
	
	//Funcio que retorna la primera linia d'un arxiu, pasada a numerica:
	function getVots($arxiu)
	{
		if (file_exists($arxiu) && !is_dir($arxiu))
		{
			$arxiuMatriu = file($arxiu);
			if (is_array($arxiuMatriu) && sizeof($arxiuMatriu) >= 1) { $primeraLinia = trim($arxiuMatriu[0]); }
			else { $primeraLinia = 0; }
			if (!is_numeric($primeraLinia)) { $primeraLinia = 0; }
		} else { $primeraLinia = 0; }
		return (int) $primeraLinia;
	}

	//Funcio que guarda els vots en l'arxiu especificat:
	function setVots($arxiu, $vots)
	{
		//Nota: no verifica si el vot es numeric! (es podria millorar).
		$totBe = $cursor = fopen($arxiu, "w"); //Si l'arxiu existeix, el trunca. Si no, l'intenta crear.
		if ($totBe) { $totBe = fputs($cursor, $vots); fclose($cursor); }
		return $totBe;
	}
	
	//Funcio que redondeixa un numero als decimals indicats:
	function redondeixa($numero, $decimals)
	{
		$numero = number_format($numero, $decimals);
		return $numero;
	}
	
	//Funcio que mostra els resultats:
	function mostraResultats()
	{
		global $enquestaDirectori;
		
		$votsSi = getVots($enquestaDirectori . "si.txt");
		$votsNo = getVots($enquestaDirectori . "no.txt");
		
		$votsTotals = $votsSi + $votsNo;
		
		echo '<table border="0" cellspacing="0" cellpadding="5" width="80%">';
		echo '<tr><td>';
		mostraGrafic("Si", $votsSi, $votsTotals, "#ff0000");
 		echo '</td></tr>';
		echo '<tr><td>';
		mostraGrafic("No", $votsNo, $votsTotals, "#0000ff");
 		echo '</td></tr>';
		echo '</table>';
	}
	
	//Funcio que mostra un grafic, amb un color definit:
	function mostraGrafic($resposta, $vots, $votsTotals, $color)
	{
		//Nota: pot passar que al redondeixar els percentatges, al sumar els dos no facin 100%. Lo ideal seria una resta de 100% - vots_anterior o alguna cosa semblant, pero bueno.
		$tantPercent = 0;
		if ($votsTotals > 0) { $tantPercent = $vots / $votsTotals * 100; }
		$graficAmple = (int) $tantPercent;
		if ($graficAmple <= 0) { $graficAmple = 1; } //Minim deixarem a l'ample del grafic un 1%.
		?>
		<table border="0" cellspacing="0" cellpadding="5" width="100%">
			<tr>
				<td width="50">
					<b><?php echo $resposta; ?></b>
				</td>
				<td>
					<table border="0" cellspacing="0" cellpadding="5" width="<?php echo $graficAmple; ?>%" height="40">
						<tr>
							<td bgcolor="<?php echo $color; ?>"></td>
						</tr>
					</table>
				</td>
				<td width="120">
					<font size="2" color="<?php echo $color; ?>" face="verdana">
					<?php
						echo "<b>$vots</b> vot";
						if ($vots != 1) { echo "s"; } //Ficarem "s" al 0 tambe.
					?>
					</font>
					<font size="1" color="<?php echo $color; ?>" face="arial">(<b><?php echo number_format($tantPercent, 2, ",", "."); ?></b>%)</font>
				</td>
			</tr>
		</table>
		<?php
	}
?>