<?php
	function creaDirectoriImatges()
	{
		$nomDirectori = DIRECTORI_IMATGES;
		
		//Si no existeix o existeix pero no es un directori, el crea:
		if (!file_exists($nomDirectori) || file_exists($nomDirectori) && !is_dir($nomDirectori))
		{
			@mkdir($nomDirectori); //Amb l'arroba no mostrara els missatges d'error.
		}
	}

	function processaFormulari($post)
	{
		global $HTTP_POST_FILES;

		$nomDirectori = DIRECTORI_IMATGES;
		
		$totBe = FALSE;
		
		if (isset($HTTP_POST_FILES)) { $post_files = $HTTP_POST_FILES; }
		else if (isset($_FILES)) { $post_files = $_FILES; }
		else { $post_files = Array(); } //Matriu buida.

		if ($post_files["arxiu"]["error"] != 0 && trim($post_files["arxiu"]["error"]) != 0) { echo "Error al pujar l'arxiu! Codi del error: " . $post_files["arxiu"]["error"]; if ($post_files["arxiu"]["error"] == 2) { echo " (el fitxer es massa gran)"; } return; }

		if (isset($post_files["arxiu"]["tmp_name"]))
		{
			//if (trim($post_files["arxiu"]["tmp_name"]) == "") { $post_files["arxiu"]["tmp_name"] = $post_files["arxiu"]["name"]; }	
			if (is_uploaded_file($post_files["arxiu"]["tmp_name"]))
			{
		    	$tamanyArxiu = $post_files["arxiu"]["size"];
				//Comprovem si el tamany es correcte (el camp hidden en el formulari amb MAX_FILE_SIZE podria fallar):
				if (arxiuValidJPEG($post_files["arxiu"]) && $tamanyArxiu <= LIMIT_TAMANY) //Es permeten arxius amb la mateixa grandaria que el limit. 
				{
					$rutaDesti = $nomDirectori . "/" . $post_files["arxiu"]["name"];
					//Si l'arxiu existeix, l'hi canvia el nom:
					$numIncremental = 0;
					while (file_exists($rutaDesti) && !is_dir($rutaDesti))
					{
						$rutaDesti = $nomDirectori . "/" . $numIncremental++ . "_" . $post_files["arxiu"]["name"];
					}
					//[No caldria per lo d'adalt] => Solament permet pujar si no existeix un arxiu amb el mateix nom (ja que si no el sobreescriuria):
					if (!file_exists($rutaDesti) || file_exists($rutaDesti) && is_dir($rutaDesti))
					{
						//Mou l'arxiu temporal al directori corresponent:
						$nomDirectori = DIRECTORI_IMATGES;
					    $totBe = move_uploaded_file($post_files["arxiu"]["tmp_name"], $rutaDesti);
					}
				}
		    } 
		}
		
		if ($totBe) { echo "Imatge ficada amb exit!"; }
		else { echo "<b>ERROR</b>: Imatge no ficada. Comprova que hagis enviat alguna cosa i sigui realment una imatge amb el format correcte. Si tot es correcte, pot ser un problema del servidor.<br><br>"; }
		
		return $totBe;
	}
	
	function arxiuValidJPEG($arxiu)
	{
		$arxiuValid = TRUE;

		//Si no es una matriu d'arxius valida, retorna false:
		if (!isset($arxiu["tmp_name"]) || !isset($arxiu["tmp_name"]["type"])) { return FALSE; }

		$nomArxiu = $arxiu["name"]; //Si fesim servir el tmp_name podria tenir una extensio .tmp o altra.
				
		//Mira si l'extensio es correcta:
		$extensionsValides = Array( "jpg", "jpeg", "gif", "png" );
		$extensioArxiu = strtolower( substr($nomArxiu, strrpos($nomArxiu, ".") + 1) );
		if (!in_array($extensioArxiu, $extensionsValides)) { $arxiuValid = FALSE; }
		
		//Mira si el tipus es correcte (a lo millor no faria falta, ja que mirem el MIME tambe):
		$tipusArxiu = strtolower($arxiu["type"]);
		$tipusValids = Array( "image/jpeg", "image/gif", "image/png" );
		if (trim($tipusArxiu) == "" || !in_array($tipusArxiu, $tipusValids)) { $arxiuValid = FALSE; }
		
		//Mira si el MIME de l'arxiu es correcte (no es d'altre tipus amb l'extensio modificada): 
		if (trim(mime_content_type($nomArxiu)) != "" && !in_array(strtolower(mime_content_type($nomArxiu)), $tipusValid)) { $arxiuValid = FALSE; }
		
		return $arxiuValid;
	}
	
	function mostraImatges() //Nota: no te en compta si son massa grans de tamany (es podria mirar amb funcions de l'extensio GD del PHP).
	{
		$cursor = opendir(DIRECTORI_IMATGES);
		
		$hiHanArxiusValids = FALSE;
		
		$numColumnes = 2;
		
		echo '<table width="100%" cellspacing="0" cellpadding="0" style="border:2px dotted #ffddff;"><tr><td colspan=" ' . $numColumnes . ' " align="center" style="background:#ffaaff; color:#0000bb; font-weight:bold; font-size:24px;"><center>Galeria d\'imatges</center></td></tr>';
		
		$f = $c = 0;
		while ($arxiu = readdir($cursor))
		{
			if (!is_dir($arxiu) && $arxiu != "." && $arxiu != "..")
			{
				$extensionsValides = Array( "jpg", "jpeg", "gif", "png" );
				$extensioArxiu = strtolower(substr($arxiu, strrpos($arxiu, ".") + 1));
				if (in_array($extensioArxiu, $extensionsValides))
				{
					$hiHanArxiusValids = TRUE;
					$arxiu = htmlentities($arxiu);
					if ($c == 0) { echo '<tr>'; }
					echo '<td align="center" style="border:2px dashed #ffaaff;"><center><a href="#" onClick="window.open(\'' . DIRECTORI_IMATGES . '/' . $arxiu . '\', \'_blank\', \'width=800,height=600,scrollbars=NO\'); return false;"><img src="' . DIRECTORI_IMATGES . '/' . $arxiu . '" alt="' . $arxiu . '" title="' . $arxiu . '" width="50" height="50"><br>' . $arxiu . '</center></td>';
					$c++;
					if ($c >= $numColumnes) { echo '</tr>'; $c = 0; $f++; }
				}
			}
		}
		
		if ($f > 0 && $c > 0 && $c < $numColumnes)
		{
			while ($c++ < $numColumnes) { echo '<td style="border:2px dashed #ffaaff;">&nbsp;</td>'; }
			echo '</tr>';
		} else if ($f <= 0 && $c > 0 && $c < numColumnes) { echo '</tr>'; }
		
		if (!$hiHanArxiusValids) { echo '<tr><td align="center"><b>No hi han imatges encara.</b></center></td></tr>'; }
		
		echo '</table><br>';
	}
?>
<html>
	<head>
		<title>Exercici 1</title>
	</head>
	<body bgcolor="#ffccff">
		<?php
			//Defineix el nom del directori de les imatges:
			define("DIRECTORI_IMATGES", "jpg");
			
			//Defineix el limit de tamany de cada arxiu (bytes):
			define("LIMIT_TAMANY", 8000); //Es permetran arxius amb la mateixa grandaria que el limit o inferiors.

			//Crea el directori de les imatges si no existeix, per si de cas:
			creaDirectoriImatges();
			
			//Recull les variables enviades per POST i les guarda en una matriu (per fer-les mes accesibles):
			if (isset($HTTP_POST_VARS)) { $post = $HTTP_POST_VARS; }
			else if (isset($_POST)) { $post = $_POST; }
			else { $post = Array(); } //Matriu buida.
			
			//Si s'ha enviat, processa el formulari:
			if (isset($post["enviat"]) && $post["enviat"] == "si") { processaFormulari($post); }
			
			//Mostra les imatges:
			mostraImatges();

			//Defineix el nom de l'arxiu actual:
			if (isset($HTTP_SERVER_VARS["PHP_SELF"])) { $scriptActual = $HTTP_SERVER_VARS["PHP_SELF"]; }
			else if (isset($_SERVER["PHP_SELF"])) { $scriptActual = $_SERVER["PHP_SELF"]; }
			else if (isset($PHP_SELF)) { $scriptActual = $PHP_SELF; }
			else { $scriptActual = "ex1.php"; }
		?>
		<form method="post" enctype="multipart/form-data" action="<?php echo $scriptActual; ?>" style="display:inline;">
			<input type="hidden" name="enviat" value="si">
			<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo LIMIT_TAMANY; ?>">
			Fica una imatge JPEG (extensio .jpg o .jpeg):
			<input type="file" name="arxiu" value="">
			<input type="submit" name="boto" value="Envia">
		</form>
		<br>
		Limit de tamany: <?php echo LIMIT_TAMANY; ?> bytes
	</body>
</html>