<?php
	//Si no estem autoritzats a accedir a aquest script, surt:
	if (!isset($autoritzat) || isset($autoritzar) && !$autoritzat) { exit(0); }
	
	//Funcio que retorna la matriu amb les variables per post:
	function getPost()
	{
		if (isset($HTTP_POST_VARS)) { $post = $HTTP_POST_VARS; }
		else if (isset($_POST)) { $post = $_POST; }
		else { $post = Array(); } //Matriu buida.
		return $post;
	}
	
	//Funcio que retorna la matriu amb les cookies:
	function getCookies()
	{
		if (isset($HTTP_COOKIE_VARS)) { $cookies = $HTTP_COOKIE_VARS; }
		else if (isset($_COOKIE)) { $cookies = $_COOKIE; }
		else { $cookies = Array(); } //Matriu buida.
		return $cookies;
	}
	
	//Funcio que retorna la primera linia d'un arxiu, pasada a numerica:
	function getVots($arxiu)
	{
		if (file_exists($arxiu) && !is_dir($arxiu))
		{
			$arxiuMatriu = file($arxiu);
			if (is_array($arxiuMatriu) && sizeof($arxiuMatriu) >= 1) { $primeraLinia = trim($arxiuMatriu[0]); }
			else { $primeraLinia = 0; }
			if (!is_numeric($primeraLinia)) { $primeraLinia = 0; }
		} else { $primeraLinia = 0; }
		return $primeraLinia;
	}

	//Funcio que guarda els vots en l'arxiu especificat:
	function setVots($arxiu, $vots)
	{
		//Nota: no verifica si el vot es numeric! (es podria millorar).
		$totBe = $cursor = fopen($arxiu, "w"); //Si l'arxiu existeix, el trunca. Si no, l'intenta crear.
		if ($totBe) { $totBe = fputs($cursor, $vots); fclose($cursor); }
		return $totBe;
	}
	
	//Funcio que redondeixa un numero als decimals indicats:
	function redondeixa($numero, $decimals)
	{
		$numero = number_format($numero, $decimals);
		return $numero;
	}
?>