<?php
	require_once "configuracio.php";

	//Funcio que fica una variable o matriu de sessio:
	function setSession($nom, $valor)
	{
		global $HTTP_SESSION_VARS;
		
		if (isset($HTTP_SESSION_VARS)) { $HTTP_SESSION_VARS[$nom] = $valor; }
		else if (isset($_SESSION)) { $_SESSION[$nom] = $valor; }
		else { $$nom = $valor; }
	}

	//Funcio que retorna la matriu amb la sessio:
	function getSession()
	{
		global $HTTP_SESSION_VARS;
		
		if (isset($HTTP_SESSION_VARS)) { $session = $HTTP_SESSION_VARS; }
		else if (isset($_SESSION)) { $session = $_SESSION; }
		else { $session = Array(); } //Matriu buida.

		return $session;
	}

	//Funcio que retorna la matriu amb les variables per post:
	function getPost()
	{
		if (isset($HTTP_POST_VARS)) { $post = $HTTP_POST_VARS; }
		else if (isset($_POST)) { $post = $_POST; }
		else { $post = Array(); } //Matriu buida.
		return $post;
	}

	//Funcio que registra un usuari:
	function registraUsuari($usuari, $clau)
	{
		//Si l'usuari ja existeix, surt:
		if (usuariExistent($usuari)) { return FALSE; }
		
		//Si no es una adrea valida d'E-Mail, surt:
		if (!esEmail($usuari)) { return FALSE; }
		
		$arxiu = ARXIU_USUARIS;
		
		//Nota: no verifica si el vot es numeric! (es podria millorar).
		$totBe = $cursor = fopen($arxiu, "a");
		if ($totBe) { $totBe = fputs($cursor, "<?php // :" . $usuari . ":" . $clau . ": ?> \r\n"); fclose($cursor); }

		return $totBe;
	}
	
	//Funcio que retorna si un usuari existeix o no:
	function usuariExistent($usuari)
	{
		$arxiu = ARXIU_USUARIS;
		
		if (!file_exists($arxiu)) { return FALSE; }
		
		$usuari = trim($usuari);
		
		$existeix = FALSE;
		
		$linies = file($arxiu);
		
		foreach ($linies as $linia)
		{
			//$linia = substr($linia, 8);
			$linia_desglosada = explode(":", $linia);
			$usuari_linia = $linia_desglosada[1];
			
			if (trim(strtolower($usuari_linia)) == trim(strtolower($usuari))) { $existeix = TRUE; break; }
		}
		
		return $existeix;
	}
	
	//Fuincio que retorna si un usuari i contrasenya son valids:
	function usuariClauValida($usuari, $clau)
	{
		$arxiu = ARXIU_USUARIS;
	
		if (!file_exists($arxiu)) { return FALSE; }
	
		if (!usuariExistent($usuari)) { return FALSE; }
		
		$usuari = trim($usuari);
		$clau = trim($clau);
		
		$existeix = FALSE;
		
		$linies = file($arxiu);
		
		foreach ($linies as $linia)
		{
			//$linia = substr($linia, 8);
			$linia_desglosada = explode(":", $linia);
			$usuari_linia = $linia_desglosada[1];
			$clau_linia = $linia_desglosada[2];
			
			if (trim(strtolower($usuari_linia)) == trim(strtolower($usuari)))
			{
				if (trim(strtolower($clau_linia)) == trim(strtolower($clau)))
				{
					$existeix = TRUE;
					break;
				}
			}
		}
		
		return $existeix;
		
	}
	
	//Funcio que retorna si una adrea es d'E-Mail o no:
	function esEmail($conta)
	{
		return eregi("^[a-z]+[_\.\-]{0,1}[a-z0-9]+@[a-z0-9]+[_\.\-]{0,1}[a-z0-9]+\.[a-z]{2,4}$", $conta);
	}
	
	//Funcio que retorna una matriu amb les marques dels fabricants:
	function getFabricants()
	{
		$arxiu = ARXIU_FABRICANTS;

		if (!file_exists($arxiu)) { return Array(); }
		
		$linies = file($arxiu);
		
		$fabricants = Array();
		foreach ($linies as $linia)
		{
			$fabricant = trim($linia);
			
			if (!in_array($fabricant, $fabricants)) { $fabricants[] = $fabricant; }
		}
		
		return $fabricants;
	}
	
	//Funcio que retorna si un fabricant existeix o no:
	function existeixFabricant($fabricant)
	{
		$fabricants = getFabricants();

		return in_array(trim($fabricant), $fabricants);
	}
	
	//Funcio que retorna una matriu amb els models d'una marca:
	function getModels($fabricant)
	{
		//Si el fabricant no existeix, retorna una matriu buida:
		if (!existeixFabricant($fabricant)) { return Array(); }

		$fabricant = trim($fabricant);
		
		$arxiu = ARXIU_MODELS;

		if (!file_exists($arxiu)) { return Array(); }
		
		$linies = file($arxiu);
		
		$models = Array();
		foreach ($linies as $linia)
		{
			$linia_desglosada = explode(";", $linia);
			$fabricant_linia = $linia_desglosada[0];

			if (trim(strtolower($fabricant)) == trim(strtolower($fabricant_linia)))
			{
				$model = $linia_desglosada[1];
				if (!in_array($model, $models)) { $models[] = trim($model); }
			}
		}
		
		return $models;
	}
	
	//Funcio que retorna si un model existeix o no, en un fabricant:
	function existeixModelFabricant($model, $fabricant)
	{
		if (!existeixFabricant($fabricant)) { return FALSE; }
		
		$models = getModels($fabricant);
		
		return in_array(trim($model), $models);
	}

	//Funcio que retorna una matriu amb els vehicles d'una marca:
	function getVehicles($model, $fabricant)
	{
		//Si el fabricant no existeix, retorna una matriu buida:
		if (!existeixModelFabricant($model, $fabricant)) { return Array(); }
		
		$fabricant = trim($fabricant);
		$model = trim($model);
		
		$arxiu = ARXIU_MODELS;

		if (!file_exists($arxiu)) { return Array(); }
		
		$linies = file($arxiu);
		
		$vehicles = Array();
		foreach ($linies as $linia)
		{
			$linia_desglosada = explode(";", $linia);
			$fabricant_linia = $linia_desglosada[0];

			if (trim(strtolower($fabricant)) == trim(strtolower($fabricant_linia)))
			{
				$vehicle = $linia_desglosada[1];
				$vehicles[] = trim($model);
			}
		}
		
		return $vehicles;
	}

	//Funcio que retorna el nombre de models que hi han d'una marca:
	function nombreVehicles($model, $fabricant)
	{
		$vehicles = getVehicles($model, $fabricant);
		
		$nombre = 0;
		
		foreach ($vehicles as $vehicle)
		{
			if (trim(strtolower($model)) == trim(strtolower($vehicle)))
			{
				$nombre++;
			}
		}
		
		return $nombre;
	}

	//Funcio que retorna una matriu amb les imatges d'un model d'un fabricant:
	function getImatges($model, $fabricant)
	{
		if (!existeixFabricant($fabricant)) { return Array(); }
		else if (!existeixModelFabricant($model, $fabricant)) { return Array(); }
		
		$arxiu = ARXIU_MODELS;

		if (!file_exists($arxiu)) { return Array(); }
		
		$linies = file($arxiu);
		
		$imatges = Array();
		foreach ($linies as $linia)
		{
			$linia_desglosada = explode(";", $linia);
			$fabricant_linia = $linia_desglosada[0];

 			if (trim(strtolower($fabricant)) == trim(strtolower($fabricant_linia)))
			{
				$model_linia = $linia_desglosada[1];
				if (trim(strtolower($model)) == trim(strtolower($model_linia)))
				{
					$imatges_matriu = $linia_desglosada;
					for ($x = 2; $x < sizeof($imatges_matriu); $x++)
					{
						$imatge = trim($imatges_matriu[$x]);
						if ($imatge != "" && file_exists("fotos/" . $imatge)) { $imatges[] = $imatge; }
					}
				}
			}
		}
		
		return $imatges;
	}


	//Funcio que mostra els vehicles d'un model d'un fabricant:
	function mostraVehiclesModelFabricants($model, $fabricant)
	{
		if (!existeixFabricant($fabricant)) { return ""; }
		else if (!existeixModelFabricant($model, $fabricant)) { return Array(); }
		
		echo "<h3>$fabricant</h3>";

		echo "<h4>Model: $model</h4>";
		
		$imatges = getImatges($model, $fabricant);

		$hiHaImatges = FALSE;
		foreach ($imatges as $imatge)
		{
			echo "$imatge<br>";
			echo '<img src="fotos/' . $imatge . '"><br><br>';
			$hiHaImatges = TRUE;
		}
		
		if (!$hiHaImatges) { echo "No te imatges"; }
	}
	
	//Funcio que mostra tots els vehicles de tots els models de tots els fabricants:
	function mostraVehicles()
	{
		$fabricants = getFabricants();
		
		foreach ($fabricants as $fabricant)
		{
			echo "<h3>$fabricant</h3>";
		
			$models = getModels($fabricant);
			foreach ($models as $model)
			{
				echo "<h4>Model: $model</h4>";
		
				$imatges = getImatges($model, $fabricant);

				$hiHaImatges = FALSE;
				foreach ($imatges as $imatge)
				{
					echo "$imatge<br>";
					echo '<img src="fotos/' . $imatge . '"><br><br>';
					$hiHaImatges = TRUE;
				}
				if (!$hiHaImatges) { echo "No te imatges"; }
			}
		}
	}
	
?>