<?php

	function creaDirectoriImatges()
	{
		$nomDirectori = DIRECTORI_IMATGES;
		
		//Si no existeix o existeix pero no es un directori, el crea:
		if (!file_exists($nomDirectori) || file_exists($nomDirectori) && !is_dir($nomDirectori))
		{
			@mkdir($nomDirectori); //Amb l'arroba no mostrara els missatges d'error.
		}
	}

	function processaFormulari($post)
	{
		global $HTTP_POST_FILES;

		$nomDirectori = DIRECTORI_IMATGES;
		
		$totBe = FALSE;
		
		if (isset($HTTP_POST_FILES)) { $post_files = $HTTP_POST_FILES; }
		else if (isset($_FILES)) { $post_files = $_FILES; }
		else { $post_files = Array(); } //Matriu buida.

		if ($post_files["foto"]["error"] != 0 && trim($post_files["foto"]["error"]) != 0) { echo "Error al pujar l'arxiu! Codi del error: " . $post_files["foto"]["error"]; if ($post_files["foto"]["error"] == 2) { echo " (el fitxer es massa gran)"; } return; }

		if (isset($post_files["foto"]["tmp_name"]))
		{
			//if (trim($post_files["foto"]["tmp_name"]) == "") { $post_files["foto"]["tmp_name"] = $post_files["foto"]["name"]; }	
			if (is_uploaded_file($post_files["foto"]["tmp_name"]))
			{
		    	$tamanyArxiu = $post_files["foto"]["size"];
				//Comprovem si el tamany es correcte (el camp hidden en el formulari amb MAX_FILE_SIZE podria fallar):
				if (arxiuValidJPEG($post_files["foto"]) && $tamanyArxiu <= LIMIT_TAMANY) //Es permeten arxius amb la mateixa grandaria que el limit. 
				{
					$rutaDesti = $nomDirectori . "/" . $post_files["foto"]["name"];
					//Si l'arxiu existeix, l'hi canvia el nom:
					$numIncremental = 0;
					while (file_exists($rutaDesti) && !is_dir($rutaDesti))
					{
						$rutaDesti = $nomDirectori . "/" . $numIncremental++ . "_" . $post_files["foto"]["name"];
					}
					//[No caldria per lo d'adalt] => Solament permet pujar si no existeix un arxiu amb el mateix nom (ja que si no el sobreescriuria):
					if (!file_exists($rutaDesti) || file_exists($rutaDesti) && is_dir($rutaDesti))
					{
						//Mou l'arxiu temporal al directori corresponent:
						$nomDirectori = DIRECTORI_IMATGES;
					    $totBe = move_uploaded_file($post_files["foto"]["tmp_name"], $rutaDesti);
					}
				}
		    } 
		}
		
		if ($totBe) { echo "Imatge ficada amb exit!"; }
		else { echo "<b>ERROR</b>: Imatge no ficada. Comprova que hagis enviat alguna cosa i sigui realment una imatge amb el format correcte. Si tot es correcte, pot ser un problema del servidor.<br><br>"; }
		
		return $totBe;
	}
	
	function arxiuValidJPEG($arxiu)
	{
		$arxiuValid = TRUE;

		//Si no es una matriu d'arxius valida, retorna false:
		if (!isset($arxiu["tmp_name"]) || !isset($arxiu["tmp_name"]["type"])) { return FALSE; }

		$nomArxiu = $arxiu["name"]; //Si fesim servir el tmp_name podria tenir una extensio .tmp o altra.
				
		//Mira si l'extensio es correcta:
		$extensionsValides = Array( "jpg", "jpeg", "gif", "png" );
		$extensioArxiu = strtolower( substr($nomArxiu, strrpos($nomArxiu, ".") + 1) );
		if (!in_array($extensioArxiu, $extensionsValides)) { $arxiuValid = FALSE; }
		
		//Mira si el tipus es correcte (a lo millor no faria falta, ja que mirem el MIME tambe):
		$tipusArxiu = strtolower($arxiu["type"]);
		$tipusValids = Array( "image/jpeg", "image/gif", "image/png" );
		if (trim($tipusArxiu) == "" || !in_array($tipusArxiu, $tipusValids)) { $arxiuValid = FALSE; }
		
		//Mira si el MIME de l'arxiu es correcte (no es d'altre tipus amb l'extensio modificada): 
		if (trim(mime_content_type($nomArxiu)) != "" && !in_array(strtolower(mime_content_type($nomArxiu)), $tipusValid)) { $arxiuValid = FALSE; }
		
		return $arxiuValid;
	}

?>