<?php
require "../adodb/adodb.inc.php"; 
/********************************************************************
** Model de classes per l'aplicaci de gesti d'un centre educatiu **
*********************************************************************/

class centre {
  public $aules;
  public $grups;
  public $alumnes;
  
  public function __construct() {
    $conn= NewADOConnection("mysql");
    $conn->Connect("localhost","root","","centre") or die ("sense connexi a la BD");
    
	//carrega de la BD els codis de les aules
    $aules = array();  
	$sql = "select codi_aula from aules";
	$rs = $conn->execute($sql) or die("error recuperant aules de la BD");
	while (!$rs->EOF) {
	  $aules[] = $rs->fields("codi_aula");
	  $rs->MoveNext();
	}
	$this->aules = $aules;
	
	//carrega de la BD els codis dels grups
    $grups = array();  
	$sql = "select codi_grup from grups";
	$rs = $conn->execute($sql) or die("error recuperant grups de la BD");
	while (!$rs->EOF) {
	  $grups[] = $rs->fields("codi_grup");
	  $rs->MoveNext();
	}
	$this->grups = $grups;
	
	//carrega de la BD els codis dels alumnes
    $alum = array();  
	$sql = "select dni from alumnes";
	$rs = $conn->execute($sql) or die("error recuperant alumnes de la BD");
	while (!$rs->EOF) {
	  $alum[] = $rs->fields("dni");
	  $rs->MoveNext();
	}
	$this->alumnes = $alum;
	
  }
} //end class	
	
 class aula {
   private $codi;
   private $especialitat;
   
   public function __construct($codi) {
    $conn= NewADOConnection("mysql");
    $conn->Connect("localhost","root","","centre") or die ("sense connexi a la BD");
	$sql = "select * from aules where codi_aula=".$codi;
	$rs = $conn->execute($sql) or die("error recuperant aules de la BD");
	if (!$rs->EOF) {
	   $this->codi=$codi;
	   $this->especialitat = $rs->fields("especialitat");
	} else {
	   die("class aula:codi d'aula inexistent->abortem");
	}
  }
  
  public function get_codi() {
    return $this->codi;
  }
  public function get_especialitat() {
    return $this->especialitat;
  }
} //end class

 class grup
 {
   private $codi_grup;
   private $especialitat;
   
   private $alumnes;
   
   public function __construct($codi)
   {
    $conn= NewADOConnection("mysql");
    $conn->Connect("localhost","root","","centre") or die ("sense connexi a la BD");
	$sql = "select * from grups where codi_grup='".$codi."'";
	$rs = $conn->execute($sql) or die("error recuperant grups de la BD");
	if (!$rs->EOF) {
	   $this->codi_grup=$codi;
	   $this->especialitat = $rs->fields("especialitat");
	} else {
	   die("class grup:codi de grup inexistent->abortem");
	}
	
	$this->carregaAlumnes();
  }

  
  public function get_codi()
  {
    return $this->codi_grup;
  }


  public function get_especialitat()
  {
    return $this->especialitat;
  }
  
  
  //Funcio que carrega els alumnes d'aquest grup:
  public function carregaAlumnes()
  {
	$conn= NewADOConnection("mysql");
	$conn->Connect("localhost","root","","centre") or die ("sense connexi a la BD");
	$sql = "select * from alumnes where grup = '".$this->get_codi()."'";
	$rs = $conn->execute($sql) or die("error recuperant grups de la BD");
	while (!$rs->EOF)
	{
	   $this->alumnes[] = new Alumne($rs->fields("dni"));
	   $rs->MoveNext();
	}
  }
  
  //Funcio que mostra els alumnes d'aquest grup, en una taula HTML:
  public function alumnes_grup()
  {
	echo '<table border="1">';

	$buit = (sizeof($this->alumnes) <= 0);

	echo '<tr><th colspan="2">Alumnes en grup amb codi ' . $this->get_codi() . '</tr>';

	if (!$buit)
	{
		echo '<tr><th>DNI</td><th>Nom</td></tr>';
	}

	foreach ($this->alumnes as $alumne)
	{
		$dni = $alumne->get_dni();
		$nom = $alumne->get_nom();
		$grup = $alumne->get_grup();
		
		echo "<tr>";
		echo '<td align="center">' . $dni . '</td>';
		echo '<td align="center">' . $nom . '</td>';
		echo "</tr>";
	}
	
	if ($buit) { echo "<tr><td colspan=\"2\">Grup buit (sense alumnes).</td></tr>"; }
	
	echo "</table>";
  }
  
} //end class

class Persona
{
	private $dni;
	private $nom;
	private $esProfessor; //Defineix si es professor o alumne.
	
	//private $grup; //Grup si es un alumne.
	//private $especialitat; //Especialitat si es professor.
	private $dades; //Especialitat si es professor.
	
   public function __construct($dni, $esProfessor)
   {
		//Defineix si es professor o alumne, tal com s'ha enviat:
		$this->esProfessor = $esProfessor;
		
		$conn= NewADOConnection("mysql");
		$conn->Connect("localhost","root","","centre") or die ("sense connexi a la BD");
		
		$taula = "alumnes";
		if ($esProfessor) { $taula = "professors"; }
		
		$sql = "select * from $taula where dni='".$dni."'";
		
		$rs = $conn->execute($sql) or die("error recuperant alumnes de la BD");
		
		if (!$rs->EOF)
		{
		   $this->dni=$dni;
		   $this->nom = $rs->fields("nom");
		   
		   if ($esProfessor)
		   {
			   $this->dades = $rs->fields("especialitat");
		   }
		   else
		   {
			   $this->dades = $rs->fields("grup");
		   }
		}
		else
		{
		   die("class alumne:dni d'alumne inexistent->abortem");
		}
  }

  public function get_dni()
  {
    return $this->dni;
  }

  public function get_dades()
  {
	return $this->dades;
  }

  public function get_nom()
  {
    return $this->nom;
  }
}

class Professor extends Persona
{
	private $especialitat;

    public function __construct($dni)
    {
   		parent::__construct($dni, TRUE); 
  		$this->especialitat = parent::get_dades();
    }
	
	public function get_especialitat()
	{
		return $this->especialitat;
	}
}

class alumne extends Persona
{
	private $grup;
	
    public function __construct($dni)
    {
   		parent::__construct($dni, FALSE);
   		$this->grup = parent::get_dades();
    }
   
	public function get_grup()
	{
		return $this->grup;
	}
} //end class


?>
  	