<?php
	//Inclueix les classes necessaries:
	require_once "tarifa.php";

	//Classe d'una habitacio:
	class Habitacio
	{
		protected $ID; //Codi unic (no es el mateix que el numero).
		protected $tipus; //Tipus d'habitacio.
		protected $numero; //Numero de l'habitacio (el que te a la porta, les centenes identifiquen el pis).
		protected $persones; //Nombre de persones que admiteix.
		protected $tarifa; //Tarifa associada a aquesta habitacio.

		public Habitacio($ID, $tipus, $numero, $persones, $tarifa)
		{
			$this->setID($ID);
			$this->setTipus($tipus);
			$this->setNumero($numero);
			$this->setPersones($persones);
			$this->setTarifa($tarifa);
		}
		
		public getID()
		{
			return $this->ID;
		}
		
		public setID($ID)
		{
			//FALTA: comprovar si el ID no existeix ja (en Alberg).
			$this->ID = trim($ID);
		}

		public getTipus()
		{
			return $this->tipus;
		}
		
		public setTipus($tipus)
		{
			$this->tipus = trim($tipus);
		}

		public getNumero()
		{
			return $this->numero;
		}
		
		public setNumero($numero)
		{
			if ($numero > 0 && $numero % 100 == 0) //Els numeros han de ser positius i multiples de 100 (les centenes marquen el pis).
			{
				$this->numero = trim($numero);
			}
		}

		public getPersones()
		{
			return $this->persones;
		}
		
		public setPersones($persones)
		{
			if ($persones > 0) //Assumirem que no hi han habitacions sense persones (com ara trasters, etc).
			{
				$this->persones = trim($persones);
			}
		}

		public getTarifa()
		{
			return $this->tarifa;
		}
		
		public setTarifa($tarifa)
		{
			//FALTA: comprovar que tarifa sigui una instancia de l'objecte Tarifa.
			$this->tarifa = trim($tarifa);
		}
		
		//Retorna si esta lliure en una data donada:
		public estaLliure($dataActual)
		{
			//FALTA: comprovar que dataActual sigui una instancia de l'objecte Data.
			//Aixo cridaria a un metode d'Alberg.
		}
		
		//Retorna si esta lliure actualment;
		public estaLliure()
		{
			$diaActual = 0; //FALTA: calcular dia actual.
			$mesActual = 0; //FALTA: calcular mes actual.
			$anyActual = 0; //FALTA: calcular any actual.
			$dataActual = new Data($diaActual, $mesActual, $anyActual);
			return $this->estaLliure($dataActual);
		}
	}
?>