<?php
	//Inclueix les classes necessaries:
	require_once "habitacio.php";
	require_once "persona.php";
	require_once "servei.php";
	require_once "regim.php";

	//Classe d'una reserva:
	class Reserva
	{
		protected ID; //Codi unic.
		
		protected habitacions; //Habitacions que inclueix la reserva.
		protected habitacioPersones; //Personas a cada habitacio (matriu amb index ID d'habitacio i valor una matriu de ID de persones).
		protected personaRegim; //Regim escollit per a cada persona.
		protected personaServeis; //Serveis (poden ser varis) per a cada persona.
		
		protected dataEntrada;
		protected dataSortida;
		
		//ENRECORDARSE: obtenirDadesReserva()
		
		public Reserva($ID, $habitacions, $habitacioPersones, $personaRegim, $personaServeis, $dataEntrada, $dataSortida)
		{
			$this->setID($ID);
			$this->setHabitacions($habitacions);
			$this->setHabitacionsPersones($habitacionsPersones);
			$this->setPersonaRegim($ID);
			$this->setPersonaServeis($personaServeis);
			$this->setDataEntrada($dataEntrada);
			$this->setDataSortida($dataSortida);
		}
		
		public getID()
		{
			return $this->ID;
		}
		
		public setID($ID)
		{
			//FALTA: comprovar si el ID no existeix ja (en Alberg).
			$this->ID = trim($ID);
		}

		public getHabitacions()
		{
			return $this->habitacions;
		}
		
		public setHabitacions($habitacions)
		{
			//FALTA: comprovar si habitacions es una matriu d'instancies de l'objecte Habitacio.
			if (is_array($habitacions))
			{
				$this->habitacions = $habitacions;
			}
		}
		
		public getHabitacionsPersones()
		{
			return $this->habitacionsPersones;
		}
		
		public setHabitacionsPersones($habitacionsPersones)
		{
			//FALTA: comprovar si habitacionsPersones es una matriu amb index que siguin ID d'habitacions existents a la reserva i de valors una matriu amb els valors que siguin ID de persones (un nombre d'elements ID persona valids per a l'habitacio a que fa referencia).
			if (is_array($habitacionsPersones))
			{
				$this->habitacionsPersones = $habitacionsPersones;
			}
		}
		
		public getPersonaRegim()
		{
			return $this->personaRegim;
		}
		
		public setPersonaRegim($personaRegim)
		{
			//FALTA: comprovar si personaRegim es una matriu d'instancies de l'objecte Regim.
			if (is_array($personaRegim))
			{
				$this->personaRegim = $personaRegim;
			}
		}

		public getPersonaServeis()
		{
			return $this->personaServeis;
		}
		
		public setPersonaServeis($personaServeis)
		{
			//FALTA: comprovar si personaRegim es una matriu d'instancies de l'objecte Servei (varies -una matriu- per a cada persona).
			if (is_array($personaServeis) && sizeof($personaServeis) > 0 && is_array($personaServeis[0]) && sizeof($personaServeis[0]) > 0)
			{
				$this->personaServeis = $personaServeis;
			}
		}
		
		public getDataEntrada()
		{
			return $this->dataEntrada;
		}
		
		public setDataEntrada($dataEntrada)
		{
			//FALTA: comprovar que dataEntrada sigui una instancia de l'objecte Data.
			$this->dataEntrada = $dataEntrada;
		}

		public getDataSortida()
		{
			return $this->dataSortida;
		}
		
		public setDataSortida($dataSortida)
		{
			//FALTA: comprovar que dataSortida sigui una instancia de l'objecte Data, i sigui posterior a la d'entrada.
			$this->dataSortida = $dataSortida;
		}


		
	}
?>