<?php
	//Inclou les classes necessaries:
	require_once "tarifa.php";
	require_once "data.php";

	//Classe d'una habitacio:
	class Habitacio
	{
		protected $ID; //Codi unic (no es el mateix que el numero).
		protected $tipus; //Tipus d'habitacio.
		protected $numero; //Numero de l'habitacio (el que te a la porta, les centenes identifiquen el pis).
		protected $persones; //Nombre de persones que admiteix.
		protected $tarifa; //Tarifa associada a aquesta habitacio.

		public function Habitacio($ID, $tipus, $numero, $persones, $tarifa)
		{
			$this->setID($ID);
			$this->setTipus($tipus);
			$this->setNumero($numero);
			$this->setPersones($persones);
			$this->setTarifa($tarifa);
		}
		
		public function getID()
		{
			return $this->ID;
		}
		
		public function setID($ID)
		{
			//FALTA: comprovar si el ID no existeix ja (en Alberg).
			$this->ID = trim($ID);
		}

		public function getTipus()
		{
			return $this->tipus;
		}
		
		public function setTipus($tipus)
		{
			$this->tipus = trim($tipus);
		}

		public function getNumero()
		{
			return $this->numero;
		}
		
		public function setNumero($numero)
		{
			if ($numero > 0 && $numero % 100 == 0) //Els numeros han de ser positius i multiples de 100 (les centenes marquen el pis).
			{
				$this->numero = trim($numero);
			}
		}

		public function getPersones()
		{
			return $this->persones;
		}
		
		public function setPersones($persones)
		{
			if ($persones > 0) //Assumirem que no hi han habitacions sense persones (com ara trasters, etc).
			{
				$this->persones = trim($persones);
			}
		}

		public function getTarifa()
		{
			return $this->tarifa;
		}
		
		public function setTarifa($tarifa)
		{
			//FALTA: comprovar que tarifa sigui una instancia de l'objecte Tarifa.
			$this->tarifa = trim($tarifa);
		}
		
		//Retorna si esta lliure en una data donada:
		public function estaLliure($dataActual)
		{
			//FALTA: comprovar que dataActual sigui una instancia de l'objecte Data.
			//Aixo cridaria a un metode d'Alberg.
		}
		
		//Retorna si esta lliure actualment;
		public function estaLliure()
		{
			$dataActual = Data.dataActual();
			$diaActual = $dataActual->getDia(); //FALTA: calcular dia actual.
			$mesActual = $dataActual->getMes(); //FALTA: calcular mes actual.
			$anyActual = $dataActual->getAny(); //FALTA: calcular any actual.
			$dataActual = new Data($diaActual, $mesActual, $anyActual);
			return $this->estaLliure($dataActual);
		}
	}
?>