<?php
	//Inclou les classes necessaries:
	require_once "temporada.php";
	require_once "regim.php";

	//Classe d'una tarifa d'una habitacio (utilizada per Habitacio):
	class Tarifa
	{
		protected $temporadaPersones; //Matriu que guarda els preus relacionats amb temporada/nombre persones (els preus han de ser per persona).
				
		public function Tarifa($temporadaPersones = NULL)
		{
			$this->setTemporadaPersones($temporadaPersones);
		}
		
		public function getTemporadaPersones()
		{
			return $this->temporadaPersones
		}
		
		public function setTemporadaPersones($temporadaPersones)
		{
			//FALTA: comprovar que la matriu sigui de ID de temporades, vinculant un nombre de persones.
			if (is_array($temporadaPersones) && sizeof($temporadaPersones) > 0 && is_array($temporadaPersones[0]))
			{
				this->temporadaPersones = $temporadaPersones;
			}
		}
		
		//Retorna el preu donada una temporada, un nombre de persones i un regim igual:
		public function getPreu($temporada, $persones, $regim)
		{
			$preu = -1;
			
			for ($x = 0; $x < $persones; $x++)
			{
				if (isset($this->temporadaPersones[$temporada][$persones]))
				{
					$preu += $temporadaPersones[$temporada][$persones] * persones + $regim->getPreu * persones;
				}
			}
			
			return $preu;
		}
		
		//Retorna el preu donada una temporada, un nombre de persones i els regims:
		public function getPreu($temporada, $persones, $regims)
		{
			$preu = -1;
			
			foreach ($regims as $regim)
			{
				$preu += $this->getPreu($temporada, 1, $regim);
			}
			
			return $preu;
		}

	}
?>