<?php
	//Inclou les classes necessaries:
	require_once "allotjament.php";


	class Allotjament extends Reserva
	{
		public function Reserva($ID, $habitacions, $habitacioPersones, $personaRegim, $personaServeis, $dataEntrada, $dataSortida)
		{
			$this->setID($ID);
			$this->setHabitacions($habitacions);
			$this->setHabitacionsPersones($habitacionsPersones);
			$this->setPersonaRegim($ID);
			$this->setPersonaServeis($personaServeis);
			$this->setDataEntrada($dataEntrada);
			$this->setDataSortida($dataSortida);
		}
		
		//Retorna la factura de la reserva:
		public function obtenirFactura($enHTML = FALSE)
		{
			$factura = "FACTURA\n\n";
			
			//Recorreix els dies:
			$dataBucle = $dataActual->copia();
			while (!$dataBucle->esIgual($dataFinal))
			{
				$factura .= "--- Data " . $dataBucle->toString() . " ---\n";
				//Recorreix les habitacions:
				foreach ($this->habitacions as $habitacio)
				{
					$factura .= "* Habitacio " . $habitacio->getNumero() . ":\n";
					//Recorreix les persones:
					$personesMatriu = $this->$habitacioPersones[$habitacio];
					foreach ($personesMatriu as $persona)
					{
						$factura .= "** Persona " . $persona->getNom() . "(" . $persona->getDNI() . ")" . ": ";
						$temporada = $dataBucle->getTemporada();
						$regim = $this->personaRegim[$persona];
						$tarifaHabitacio = $habitacio->getTarifa();
						$preu = $tarifaHabitacio->getPreu($temporada, 1, $regim); //Suma el preu d'aquesta habitacio per persona tenint en compta la temporada i el regim.
						$factura .= "$preu\n";
						//Recorreix els serveis addicionals escollits per aquesta persona:
						foreach ($this->personaServeis[$persona] as $servei)
						{
							$preu = $servei->getPreu(); //Suma el preu dels serveis d'aquesta persona.
							$factura .= "*** " . $servei->getNom() . ": $preu\n";
						}
					}
				}

				$dataBucle = $dataBucle->diaSeguent();
			}
			
			if ($enHTML) { $factura = nl2br($factura); }

			return $factura;

		}
	}
?>