<?php
	//Inclou les classes necessaries:
	require_once "habitacio.php";
	require_once "persona.php";
	require_once "servei.php";
	require_once "regim.php";
	require_once "data.php";
	require_once "temporada.php";


	//Classe d'una reserva:
	class Reserva
	{
		protected $ID; //Codi unic.
		
		protected $habitacions; //Habitacions que inclueix la reserva.
		protected $habitacioPersones; //Personas a cada habitacio (matriu amb index d'habitacio i valor una matriu de persones).
		protected $personaRegim; //Regim escollit per a cada persona.
		protected $personaServeis; //Serveis (poden ser varis) per a cada persona.
		
		protected $dataEntrada;
		protected $dataSortida;
		
		public function Reserva($ID, $habitacions, $habitacioPersones, $personaRegim, $personaServeis, $dataEntrada, $dataSortida)
		{
			$this->setID($ID);
			$this->setHabitacions($habitacions);
			$this->setHabitacionsPersones($habitacionsPersones);
			$this->setPersonaRegim($ID);
			$this->setPersonaServeis($personaServeis);
			$this->setDataEntrada($dataEntrada);
			$this->setDataSortida($dataSortida);
		}
		
		public function getID()
		{
			return $this->ID;
		}
		
		public function setID($ID)
		{
			//FALTA: comprovar si el ID no existeix ja (en Alberg).
			$this->ID = trim($ID);
		}

		public function getHabitacions()
		{
			return $this->habitacions;
		}
		
		public function setHabitacions($habitacions)
		{
			//FALTA: comprovar si habitacions es una matriu d'instancies de l'objecte Habitacio.
			if (is_array($habitacions))
			{
				$this->habitacions = $habitacions;
			}
		}
		
		public function getHabitacionsPersones()
		{
			return $this->habitacionsPersones;
		}
		
		public function setHabitacionsPersones($habitacionsPersones)
		{
			//FALTA: comprovar si habitacionsPersones es una matriu amb index que siguin d'habitacions existents a la reserva i de valors una matriu amb els valors que siguin de persones (un nombre d'elements persona valids per a l'habitacio a que fa referencia).
			if (is_array($habitacionsPersones))
			{
				$this->habitacionsPersones = $habitacionsPersones;
			}
		}
		
		public function getPersonaRegim()
		{
			return $this->personaRegim;
		}
		
		public function setPersonaRegim($personaRegim)
		{
			//FALTA: comprovar si personaRegim es una matriu d'instancies de l'objecte Persona com a index i objectes Regim com a valors.
			if (is_array($personaRegim))
			{
				$this->personaRegim = $personaRegim;
			}
		}

		public function getPersonaServeis()
		{
			return $this->personaServeis;
		}
		
		public function setPersonaServeis($personaServeis)
		{
			//FALTA: comprovar si personaServeis es una matriu d'instancies de l'objecte Servei (varies -una matriu- per a cada persona).
			if (is_array($personaServeis) && sizeof($personaServeis) > 0 && is_array($personaServeis[0]) && sizeof($personaServeis[0]) > 0)
			{
				$this->personaServeis = $personaServeis;
			}
		}
		
		public function getDataEntrada()
		{
			return $this->dataEntrada;
		}
		
		public function setDataEntrada($dataEntrada)
		{
			//FALTA: comprovar que dataEntrada sigui una instancia de l'objecte Data.
			$this->dataEntrada = $dataEntrada;
		}

		public function getDataSortida()
		{
			return $this->dataSortida;
		}
		
		public function setDataSortida($dataSortida)
		{
			//FALTA: comprovar que dataSortida sigui una instancia de l'objecte Data, i sigui posterior a la d'entrada.
			$this->dataSortida = $dataSortida;
		}

		//Retorna el preu d'aquesta reserva:
		public function getPreu()
		{
			$preu = 0;
			
			//Recorreix els dies:
			$dataBucle = $dataActual->copia();
			while (!$dataBucle->esIgual($dataFinal))
			{
				//Recorreix les habitacions:
				foreach ($this->habitacions as $habitacio)
				{
					//Recorreix les persones:
					$personesMatriu = $this->$habitacioPersones[$habitacio];
					foreach ($personesMatriu as $persona)
					{
						$temporada = $dataBucle->getTemporada();
						$regim = $this->personaRegim[$persona];
						$tarifaHabitacio = $habitacio->getTarifa();
						$preu += $tarifaHabitacio->getPreu($temporada, 1, $regim); //Suma el preu d'aquesta habitacio per persona tenint en compta la temporada i el regim.
						//Recorreix els serveis addicionals escollits per aquesta persona:
						foreach ($this->personaServeis[$persona] as $servei)
						{
							$preu += $servei->getPreu(); //Suma el preu dels serveis d'aquesta persona.
						}
					}
				}

				$dataBucle = $dataBucle->diaSeguent();
			}
			
			return $preu;
		}
	}
?>