<?php
	require_once "../classes/bd.php";
	require_once "../classes/habitacio.php";

	//Retorna un vector amb les habitacions existents a la BD:
	function carregaHabitacions()
	{
		$bd = new BaseDades();
		
		$bd->connecta();
		$bd->selecciona();
		
		$resultats = $bd->consulta("SELECT * FROM habitacions");
		
		$habitacions = Array();
		
		while ($col = mysql_fetch_assoc($resultats))
		{
			$numero = $col["Numero"];
			$capacitat = $col["Capacitat"];
			$categoria = $col["Categoria"];
			
			$habitacio = new Habitacio(0, $categoria, $numero, $capacitat, NULL);

			$habitacions[] = $habitacio;
			
			//echo "<br>" . $habitacio->getNumero() . "<br>";
		}
		
		$bd->desconnecta();
		
		return $habitacions;
	}
	
	//Retorna un vector amb les habitacions existents a la BD:
	function carregaHabitacionsLliures($dataInici, $dataFinal)
	{
		$habitacionsTotes = carregaHabitacions();
		
		$bd = new BaseDades();
		
		$bd->connecta();
		$bd->selecciona();
		
		//Pasa les dates de format dd-mm-aaaa a aaaa-mm-dd, que es el que enten mySQL:
		$terminis = explode("-", $dataInici);
		$dataInici = $terminis[2] . "-" . $terminis[1] . "-" . $terminis[0];
		$terminis = explode("-", $dataFinal);
		$dataFinal = $terminis[2] . "-" . $terminis[1] . "-" . $terminis[0];

		//Sellecciona totes les habitacions que en aquest periode estan ocupades:
		//$consulta = "SELECT * FROM habitacions AS a JOIN reserves AS b JOIN reserva_habitacions AS c ON a.Numero = c.Num_habitacio AND b.Num_reserva = c.Num_reserva WHERE '$dataInici' >= b.Data_ent AND '$dataInici' <= b.Data_surt OR '$dataFinal' <= b.Data_surt AND '$dataFinal' >= b.Data_ent";
		$consulta = "SELECT * FROM habitacions AS a JOIN reserves AS b JOIN reserva_habitacions AS c ON a.Numero = c.Num_habitacio AND b.Num_reserva = c.Num_reserva WHERE '$dataInici' BETWEEN b.Data_ent AND b.Data_surt OR '$dataFinal' BETWEEN b.Data_surt AND b.Data_ent";
		echo "consulta:<br><b>$consulta</b>";
		$resultats = $bd->consulta($consulta);
		
		$habitacionsOcupades = Array();
		
		while ($col = mysql_fetch_assoc($resultats))
		{
			$numero = $col["Numero"];
			$capacitat = $col["Capacitat"];
			$categoria = $col["Categoria"];
			
			$habitacio = new Habitacio(0, $categoria, $numero, $capacitat, NULL);

			$habitacionsOcupades[] = $habitacio;
			
			echo "<br>" . $habitacio->getNumero() . "<br>";
		}
		
		$bd->desconnecta();
		
		$habitacionsLliures = Array();
		
		//Fica en una matriu les habitacions que no estan ocupades:
		foreach ($habitacionsTotes as $habitacio)
		{
			if (!in_array($habitacio, $habitacionsOcupades)) { $habitacionsLliures[] = $habitacio; }
		}
		
		return $habitacionsLliures;
	}
?>