<?php
	require_once "../classes/bd.php";
	require_once "../classes/habitacio.php";
	require_once "../funcions/error.php";
	require_once "../funcions/carregaHabitacions.php";
	//require_once "../funcions/carregaReserves.php";

	//Mostra les habitacions disponibles donada una data d'inici i una final:
	function habitacionsDisponibles($dataInici, $dataFinal)
	{
		//Nota: no comprova que la data de inici sigui sempre anterior a la data final.

		if (trim($dataInici) == "" || trim($dataFinal) == "") { mostrar_error("Falten dades"); return; }

		$habitacions = carregaHabitacionsLliures($dataInici, $dataFinal);
		//$reserves = carregaReserves();
		
		if (is_array($habitacions) && sizeof($habitacions) > 0)
		{
			echo "<h2>Habitacions disponibles:</h2>";
			echo '<table border="0" cellspacing="0" cellpadding="10" width="90%" style="border:1px solid;">';
			foreach ($habitacions as $habitacio)
			{
				echo "<tr>";
				
				echo "<td align=\"center\"><h3>Habitaci&oacute; " . $habitacio->getNumero() . "</h3></td>";
				
				echo "</tr>";
				
				echo "<tr><td>Numero: " . $habitacio->getNumero() . "</td></tr>";
				echo "<tr><td>Categoria: " . $habitacio->getTipus() . "</td></tr>";
				echo "<tr><td>Capacitat: " . $habitacio->getPersones() . "<hr></td></tr>";
				
				echo "</tr>";
			}
			echo "</table><br>";
		}
		else { echo "<b>No hi han habitacions disponibles</b>"; }
	}
?>