CREATE TABLE IF NOT EXISTS LOCALS
(
id_local INT AUTO_INCREMENT PRIMARY KEY,
id_propietari INT NOT NULL,
id_adresa INT UNIQUE NOT NULL,
codi_local VARCHAR (10) UNIQUE NOT NULL,
tipus ENUM ('botiga_magatzem', 'oficina', 'polivalent', 'immoble') NOT NULL,
superficie DECIMAL (10, 2),
caracteristiques TINYTEXT,
restriccions TINYTEXT,
preu DECIMAL (10, 2),
actiu BOOLEAN,
FOREIGN KEY (id_propietari) REFERENCES propietaris (id_propietari) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_adresa) REFERENCES adreses (id_adresa) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS BOTIGUES_MAGATZEM
(
id_botiga_magatzem INT AUTO_INCREMENT PRIMARY KEY,
id_local INT NOT NULL,
volum DECIMAL (10, 2),
FOREIGN KEY (id_local) REFERENCES locals (id_local) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS OFICINES
(
id_oficina INT AUTO_INCREMENT PRIMARY KEY,
id_local INT NOT NULL,
FOREIGN KEY (id_local) REFERENCES locals (id_local) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS POLIVALENTS
(
id_polivalent INT AUTO_INCREMENT PRIMARY KEY,
id_local INT NOT NULL,
caracteristiques_polivalent TINYTEXT,
FOREIGN KEY (id_local) REFERENCES locals (id_local) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS IMMOBLES
(
id_immoble INT AUTO_INCREMENT PRIMARY KEY,
id_local INT NOT NULL,
FOREIGN KEY (id_local) REFERENCES locals (id_local) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS IMMOBLE_BOTIGA_MAGATZEM
(
id_immoble INT NOT NULL,
id_botiga_magatzem INT NOT NULL,
FOREIGN KEY (id_immoble) REFERENCES immobles (id_immoble) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_botiga_magatzem) REFERENCES botigues_magatzem (id_botiga_magatzem) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_immoble, id_botiga_magatzem)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS IMMOBLE_OFICINA
(
id_immoble INT NOT NULL,
id_oficina INT NOT NULL,
FOREIGN KEY (id_immoble) REFERENCES immobles (id_immoble) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_oficina) REFERENCES oficines (id_oficina) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_immoble, id_oficina)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS IMMOBLE_POLIVALENT
(
id_immoble INT NOT NULL,
id_polivalent INT NOT NULL,
FOREIGN KEY (id_immoble) REFERENCES immobles (id_immoble) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_polivalent) REFERENCES polivalents (id_polivalent) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_immoble, id_polivalent)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS ZONES
(
id_zona INT AUTO_INCREMENT PRIMARY KEY,
codi_zona VARCHAR (4) UNIQUE NOT NULL,
descripcio VARCHAR (255) DEFAULT ''
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS ENTITATS
(
id_entitat INT AUTO_INCREMENT PRIMARY KEY,
nif VARCHAR (10) UNIQUE NOT NULL,
tipus ENUM ('persona', 'empresa') NOT NULL
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS PERSONES
(
id_persona INT AUTO_INCREMENT PRIMARY KEY,
id_entitat INT NOT NULL,
nom VARCHAR (125) NOT NULL,
cognom1 VARCHAR (125) NOT NULL,
cognom2 VARCHAR (125),
FOREIGN KEY (id_entitat) REFERENCES entitats (id_entitat) ON DELETE CASCADE ON UPDATE CASCADE

) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS EMPRESES
(
id_empresa INT AUTO_INCREMENT PRIMARY KEY,
id_entitat INT NOT NULL,
rao_social VARCHAR (125) UNIQUE NOT NULL,
FOREIGN KEY (id_entitat) REFERENCES entitats (id_entitat) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS CLIENTS
(
id_client INT AUTO_INCREMENT PRIMARY KEY,
id_entitat INT NOT NULL,
FOREIGN KEY (id_entitat) REFERENCES entitats (id_entitat) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS USUARIS
(
id_usuari INT AUTO_INCREMENT PRIMARY KEY,
id_persona INT NOT NULL,
tipus ENUM ('agent', 'inspector', 'venedor') NOT NULL,
FOREIGN KEY (id_persona) REFERENCES persones (id_persona) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS PROPIETARIS
(
id_propietari INT AUTO_INCREMENT PRIMARY KEY,
id_client INT NOT NULL,
actiu BOOLEAN,
FOREIGN KEY (id_client) REFERENCES clients (id_client) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS LLOGATERS
(
id_llogater INT AUTO_INCREMENT PRIMARY KEY,
id_client INT NOT NULL,
id_preferencies INT NOT NULL,
actiu BOOLEAN,
FOREIGN KEY (id_client) REFERENCES clients (id_client) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_preferencies) REFERENCES cerques (id_cerca) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS TELEFONS
(
id_telefon INT AUTO_INCREMENT PRIMARY KEY,
telefon VARCHAR (25) UNIQUE NOT NULL
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS TELEFON_ENTITAT
(
id_telefon INT NOT NULL,
id_entitat INT NOT NULL,
FOREIGN KEY (id_telefon) REFERENCES telefons (id_telefon) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_entitat) REFERENCES entitats (id_entitat) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_telefon, id_entitat)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS ADRESES
(
id_adresa INT AUTO_INCREMENT PRIMARY KEY,
id_zona INT NOT NULL,
adresa VARCHAR (255) NOT NULL,
FOREIGN KEY (id_zona) REFERENCES zones (id_zona) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS ADRESA_ENTITAT
(
id_adresa INT NOT NULL,
id_entitat INT NOT NULL,
FOREIGN KEY (id_adresa) REFERENCES adreses (id_adresa) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_entitat) REFERENCES entitats (id_entitat) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_adresa, id_entitat)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS COMPTES
(
id_compte INT AUTO_INCREMENT PRIMARY KEY,
id_entitat INT NOT NULL,
nom VARCHAR (20) UNIQUE NOT NULL,
clau VARCHAR (20) NOT NULL,
FOREIGN KEY (id_entitat) REFERENCES entitats (id_entitat) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS CERQUES
(
id_cerca INT AUTO_INCREMENT PRIMARY KEY,
superficie_minima DECIMAL (10, 2) NOT NULL,
data_inici DATE,
data_fi DATE,
preu DECIMAL (10, 2),
caracteristiques TINYTEXT,
tipus ENUM ('tots', 'botiga_magatzem', 'oficina', 'polivalent', 'immoble') NOT NULL
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS CERCA_COMPTE
(
id_cerca INT NOT NULL,
id_compte INT NOT NULL,
FOREIGN KEY (id_cerca) REFERENCES cerques (id_cerca) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_compte) REFERENCES comptes (id_compte) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_cerca, id_compte)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS CERCA_ZONA
(
id_cerca INT NOT NULL,
id_zona INT NOT NULL,
FOREIGN KEY (id_cerca) REFERENCES cerques (id_cerca) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_zona) REFERENCES zones (id_zona) ON DELETE CASCADE ON UPDATE CASCADE,
PRIMARY KEY (id_cerca, id_zona)
) TYPE = INNODB;

CREATE TABLE IF NOT EXISTS CONTRACTES
(
id_contracte INT AUTO_INCREMENT PRIMARY KEY,
id_propietari INT NOT NULL,
id_local INT NOT NULL,
id_llogater INT NOT NULL,
data_inici DATE NOT NULL,
data_fi DATE,
actiu BOOLEAN,
FOREIGN KEY (id_propietari) REFERENCES propietaris (id_propietari) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_local) REFERENCES locals (id_local) ON DELETE CASCADE ON UPDATE CASCADE,
FOREIGN KEY (id_llogater) REFERENCES llogater (id_llogater) ON DELETE CASCADE ON UPDATE CASCADE
) TYPE = INNODB;