﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using BaseDatosNamespace;

namespace LlogaTotGestio
{
    public partial class FormPrincipal : Form
    {
        static public BD baseDatos = null; //Objecte manegador de la base de dades.
        static public bool finestraOberta = false;

        public FormPrincipal()
        {
            InitializeComponent();
        }

        private void FormPrincipal_Load(object sender, EventArgs e)
        {
            //Conecta a la base de dades:
            FormPrincipal.baseDatos = new BD("root", "", "localhost", "immobiliaria");
            FormPrincipal.baseDatos.conecta();

            //Desactiva el menu
            menuStrip1.Enabled = false;

            //Carrega el FormLogin amb el LoginControl per entrar a l'aplicacio
            FormLogin loginChildForm = new FormLogin();
            loginChildForm.MdiParent = this;
            loginChildForm.Show();
            loginChildForm.Left = this.Width / 2 - loginChildForm.Width / 2;
            loginChildForm.Top = this.Height / 2 - loginChildForm.Height / 2;
        }

        //Metode que s'executa al tancar el form principal (quan el programa termina):
        private void FormPrincipal_FormClosed(object sender, FormClosedEventArgs e)
        {
            //Desconecta de la base de dades:
            if (FormPrincipal.baseDatos != null) { FormPrincipal.baseDatos.desconecta(); }
        }

        //Metode que executa FormGestio per gestionar totes les taules (al fer click en la opcio Totes del menu):
        private void totesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("tots");
        }

        private void venedorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("agents");
        }

        private void inspectorsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("inspectors");
        }

        private void venedorsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("venedors");
        }

        private void empresesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("clientsEmpreses");
        }

        private void particularsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("clientsParticulars");
        }

        private void usuarisToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            carregaFormGestio("comptes");
        }

        private void mostrarTotsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mostrarSolamentAlquilatsToolStripMenuItem.Checked = false;
            mostrarSolamentLliuresToolStripMenuItem.Checked = false;
        }

        private void mostrarSolamentAlquilatsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mostrarTotsToolStripMenuItem.Checked = false;
            mostrarSolamentLliuresToolStripMenuItem.Checked = false;
        }

        private void mostrarSolamentLliuresToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mostrarSolamentAlquilatsToolStripMenuItem.Checked = false;
            mostrarTotsToolStripMenuItem.Checked = false;
        }

        private String opcioFiltreLocals()
        {
            if (mostrarSolamentAlquilatsToolStripMenuItem.Checked)
                return "alquilats";
            if (mostrarSolamentLliuresToolStripMenuItem.Checked)
                return "lliures";
            else
                return "tots";
        }

        private void immoblesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("immobles_" + opcioFiltreLocals() );
        }

        private void polivalentsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("polivalents_" + opcioFiltreLocals() );
        }

        private void oficinesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("oficines_" + opcioFiltreLocals() );
        }

        private void botiguesMagatzemToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("bm_" + opcioFiltreLocals() );
        }

        private void vigentsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("contractesVigents");
        }

        private void acabatsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("contractesAcabats");
        }

        private void totsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            carregaFormGestio("contractesTots");
        }


        //Metode que carrega el formulari de gestio:
        private void carregaFormGestio(String opcioMenu)
        {
            //Si no hi ha cap formulari de gestio actiu:
            if (!FormPrincipal.finestraOberta)
            {
                //Mostra el formulari de gestio:
                this.menuStrip1.Enabled = false; //Desactiva el menu d'aquest MDI.
                FormGestio gestioChildForm = new FormGestio(opcioMenu);
                gestioChildForm.MdiParent = this;
                gestioChildForm.Show();
            }
        }
    }
}

