<?php
class Entitat
{
	private $idEntitat; //int. Id de la entiat
	private $nif; //String. Identificador legal de la entitat
	private $tipus; //String. Identifica si la entitat es tracta de una persona o empresa
	private $telefons; //Array de Telefon. Telefons de contacte de l'entitat
	private $adreses; //Array de Adresa. Adreses de l'entitat
	private $compte; //Compte de la entitat (si en te)
	//private $locals; //Array de Local (els que coincideixen amb la cerca).

	function __construct($idEntitat = "")
	{
		$this->setIdEntitat($idEntitat);
		if ($this->idEntitat != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdEntitat($idEntitat)
	{
		$this->idEntitat = $idEntitat;
	}
	
	public function getIdEntitat()
	{
		return $this->idEntitat;
	}
	
	public function setNif($nif)
	{
		$this->nif = $nif;
	}
	
	public function getNif()
	{
		return $this->nif;
	}
	
	public function setTipus($tipus)
	{
		$this->tipus = $tipus;
	}
	
	public function getTipus()
	{
		return $this->tipus;
	}

	public function setTelefons($telefons)
	{
		$this->telefons = $telefons;
	}
	
	public function getTelefons()
	{
		return $this->telefons;
	}

	public function setAdreses($adreses)
	{
		$this->adreses = $adreses;
	}
	
	public function getAdreses()
	{
		return $this->telefons;
	}

	public function setCompte(Compte $compte)
	{
		$this->compte = $compte;
	}
	
	public function getCompte()
	{
		return $this->compte;
	}
	
	public function setLocals($locals)
	{
		$this->locals = $locals;
	}
	
	public function getLocals()
	{
		return $this->locals;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM entitats WHERE id_entitat = ".$this->idEntitat;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->nif = $row["nif"];
			$this->tipus = $row["tipus"];
		}
		$this->telefons = Array();
		$this->adreses = Array();
		$this->carregaTelefons();
		$this->carregaAdreses();
		
		$instruccio = "SELECT id_compte FROM comptes WHERE id_entitat = ".$this->idEntitat;
		$resultat = $bd->consulta($instruccio);

		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->compte = new Compte($row["id_compte"]);
		}
	}
	
	public function carregaTelefons()
	{
		global $bd;
		$instruccio = "SELECT id_telefon FROM telefon_entitat WHERE id_entitat = ".$this->idEntitat;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->telefons[] = new Telefon($row["id_adresa"]);
		}
	}
	
	public function carregaAdreses()
	{
		global $bd;
		$instruccio = "SELECT id_adresa FROM adresa_entitat WHERE id_entitat = ".$this->idEntitat;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->adreses[] = new Telefon($row["id_adresa"]);
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}

	public function obtenirIdEntitat($idCompte)
	{
		global $bd;
		$instruccio = "SELECT id_entitat FROM comptes WHERE id_compte = ".$idCompte;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
			$this->setIdEntitat($row["id_entitat"]);
		
		$this->carregaDades();
	}
	
	public function esAdministrador()
	{
		global $bd;
		$instruccio = "SELECT * FROM comptes AS a JOIN entitats AS b ON a.id_entitat = b.id_entitat WHERE a.nom LIKE 'admin' AND a.id_entitat = ". $this->idEntitat;
		$resultat = $bd->consulta($instruccio);
		if (mysql_fetch_assoc($resultat))
			return true;
		else
			return false;
	}
	
	public function esUsuari()
	{
		global $bd;
		$instruccio = "SELECT * FROM usuaris AS a JOIN persones AS b ON a.id_persona = b.id_persona JOIN entitats AS c ON b.id_entitat = c.id_entitat WHERE c.id_entitat = ". $this->idEntitat;
		$resultat = $bd->consulta($instruccio);
		if (mysql_fetch_assoc($resultat))
			return true;
		else
			return false;
	}
	
	public function esClient()
	{
		global $bd;
		$instruccio = "SELECT * FROM clients AS a JOIN entitats AS b ON a.id_entitat = b.id_entitat WHERE a.id_entitat = ". $this->idEntitat;
		$resultat = $bd->consulta($instruccio);
		if (mysql_fetch_assoc($resultat))
			return true;
		else
			return false;
	}
}//Fi Clase Entitat

class Persona extends Entitat
{
	private $idPersona; //int. Id de la persona
	private $nom; //String. Nom de la persona
	private $cognom1; //String. Primer cognom de la persona
	private $cognom2; //String. Segon cognom de la persona
	
	function __construct($idPersona = "")
	{
		if (!$this->idPersona == "")
		{
			$this->setIdPersona($idPersona);
			$this->carregaDades();
		}
	}
	
	protected function setIdPersona($idPersona)
	{
		$this->idPersona = $idPersona;
	}
	
	public function getIdPersona()
	{
		return $this->idPersona;
	}
	
	public function setNom($nom)
	{
		$this->nom = $nom;
	}
	
	public function getNom()
	{
		return $this->nom;
	}

	public function setCognom1($cognom1)
	{
		$this->cognom1 = $cognom1;
	}
	
	public function getCognom1()
	{
		return $this->cognom1;
	}

	public function setCognom2($cognom2)
	{
		$this->cognom2 = $cognom2;
	}
	
	public function getCognom2()
	{
		return $this->cognom2;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM persones WHERE id_persona = ".$this->idPersona;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->nom = $row["nom"];
			$this->cognom1 = $row["cognom1"];
			$this->cognom2 = new Compte($row["cognom2"]);
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  *
	  */
	}	
}//Fi Clase Persona

class Empresa extends Entitat
{
	private $idEmpresa; //int. Id de la empresa
	private $raoSocial; //String. Nom de la empresa
	
	function __construct($idEmpresa = "")
	{
		$this->setIdEmpresa($idEmpresa);
		if ($this->idEmpresa != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdEmpresa($idEmpresa)
	{
		$this->idEmpresa = $idEmpresa;
	}
	
	public function getIdEmpresa()
	{
		return $this->idEmpresa;
	}
	
	public function setRaoSocial($raoSocial)
	{
		$this->raoSocial = $raoSocial;
	}
	
	public function getRaoSocial()
	{
		return $this->raoSocial;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{/*SELECT de totes les dades a partir del idAdrea*/
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  *
	  */
	}
}//Fi clase Empresa

class Client extends Entitat
{
	public $idClient; //int. id del client
	
	function __construct($idClient = "")
	{
		$this->setIdClient($idClient);
	}
	protected function setIdClient($idClient)
	{
		$this->idClient = $idClient;
	}
	
	public function getIdClient()
	{
		return $this->idClient;
	}
}//Fi Clase Client

class Usuari extends Entitat
{
	private $idUsuari; //int. Id del usuari
	private $tipus; // Tipus d'usuari, empresa
	
	function __construct($idUsuari = "")
	{
		$this->setIdUsuari($idUsuari);
		if ($this->idUsuari != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdUsuari($idUsuari)
	{
		$this->idUsuari = $idUsuari;
	}
	
	public function getIdUsuari()
	{
		return $this->idUsuari;
	}

	public function setTipus($tipus)
	{
		$this->tipus = $tipus;
	}
	
	public function getTipus()
	{
		return $this->tipus;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM usuaris WHERE id_usuari = ".$this->idUsuari;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->tipus = $row["tipus"];
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  *
	  */
	}	
}//Fi Clase Usuari

class Propietari extends Entitat
{
	private $idPropietari;
	private $contractes;
	private $locals;
	private $actiu;
	
	function __construct($idPropietari = "")
	{
		$this->setIdPropietari($idPropietari);
		if ($this->idPropietari != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdUsuari($idPropietari)
	{
		$this->idUsuari = $idUsuari;
	}
	
	protected function setIdPropietari($idPropietari)
	{
		$this->idPropietari = $idPropietari;
	}
	
	public function getIdPropietari()
	{
		return $this->idPropietari;
	}
	
	public function setContractes($contractes)
	{
		$this->contractes = $contractes;
	}
	
	public function getContractes()
	{
		return $this->contractes;
	}
	
	public function setLocals($locals)
	{
		$this->locals = $locals;
	}
	
	public function getLocals()
	{
		return $this->locals;
	}
	
	public function setActiu($actiu)
	{
		$this->actiu = $actiu;
	}

	public function getActiu()
	{
		return $this->actiu;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{	
		global $bd;
		$instruccio = "SELECT * FROM propietaris WHERE id_propietat = ".$this->idPropietat;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->actiu = new Compte($row["actiu"]);
		}
		$this->contractes = Array();
		$this->locals = Array();
		$this->carregaContractes();
		$this->carregaLocals();
	}
	
	public function carregaContractes()
	{
		global $bd;
		$instruccio = "SELECT id_contracte FROM contractes WHERE id_propietari = ".$this->idPropietari;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->contractes[] = new Contracte($row["id_contracte"]);
		}
	}
	
	public function carregaLocals()
	{
		global $bd;
		$instruccio = "SELECT id_local FROM locals WHERE id_propietari = ".$this->idPropietari;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->locals[] = new Local($row["id_local"]);
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  *
	  */
	}
}//Fi Clase Propietari

class Llogater extends Client
{
	private $idLlogater; //int. Id del llogater
	private $cerques; //Array de Cerca. Array de cerques del usuari
	private $contractes; //Array de Contracte. Array del contractes actius vincultats amb el llogater
	private $locals; //Array de Local. Array de locals que te llogats el llogater
	private $actiu; //Boolean si esta el llogater donat de alta o no
				   //False: Esta donat de baixa
				   //True: El contracte encara esta vigent
	
	function __construct($idLlogater = "")
	{
		$this->setIdLlogater($idLlogater);
		if ($this->idLlogater != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdLlogater($idLlogater)
	{
		$this->idLlogater = $idLlogater;
	}	
	
	public function getIdLlogater()
	{
		return $this->idLlogater;
	}
		
	public function setCerques($cerques)
	{
		$this->cerques = $cerques;
	}	
	
	public function getCerques()
	{
		return $this->cerques;
	}
		
	public function setContractes($contractes)
	{
		$this->contractes = $contractes;
	}	
	
	public function getContractes()
	{
		return $this->contractes;
	}
		
	public function setLocals($locals)
	{
		$this->locals = $locals;
	}	
	
	public function getLocals()
	{
		return $this->locals;
	}
		
	public function setActiu($actiu)
	{
		$this->actiu = $actiu;
	}	
	
	public function isActiu()
	{
		return $this->actiu;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM persones WHERE id_persona = ".$this->idPersona;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->cerques = new Cerca($row["id_preferencies"]);
			$this->actiu = $row["actiu"];
		}
		$this->contractes = Array();
		$this->locals = Array();
		$this->carregaLocals();
		$this->carregaContractes();
	}
	
	public function carregaLocals()
	{
		global $bd;
		$instruccio = "SELECT id_local FROM llogaters AS a JOIN contractes AS b ON a.id_llogater = b.id_llogater JOIN locals AS c ON b.id_local = c.id_local WHERE a.id_llogater = ". $this->idLlogater;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->Locals[] = new Locals($row["id_local"]);
		}
	}
	
	public function carregaContractes()
	{
		global $bd;
		$instruccio = "SELECT id_contracte FROM contractes WHERE id_llogater = ".$this->idLlogater;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->adreses[] = new Contractes($row["id_adresa"]);
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  *
	  */
	}
}

class Compte
{
	private $idCompte; //int Id del compte
	private $nom; //String. Nom d'access personal
	private $clau; //String. Clau d'access personal
	private $cerques; //Array de Cerca. Ultimes cerques del compte
	
	function __construct($idCompte = "")
	{	
		$this->setIdCompte($idCompte);
		if ($this->idCompte != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdCompte($idCompte)
	{
		$this->idCompte = $idCompte;
	}
	
	public function getIdCompte()
	{
		return $this->idCompte;
	}

	public function setNom($nom)
	{
		$this->nom = $nom;
	}

	public function getNom()
	{
		return $this->nom;
	}

	public function setClau($clau)
	{
		$this->nom = $nom;
	}

	public function getClau()
	{
		return $this->clau;
	}

	public function setCerques($cerques)
	{
		$this->cerques = $cerques;
	}

	public function getCerques()
	{
		return $this->cerques;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM comptes WHERE id_compte = ".$this->idCompte;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->idCompte = $row["id_compte"];
			$this->nom = $row["nom"];;
			$this->clau = $row["clau"];;
		}
		$this->cerques = Array();
		$this->carregaCerques();
	}
	
	protected function carregaCerques()
	{
		global $bd;
		$instruccio = "SELECT id_cerca FROM cerca_compte WHERE id_compte = ".$this->idCompte;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->cerques[] = new Cerca($row["id_cerca"]);
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  *
	  */
	}
}//Fi Classe Compte

class Cerca
{
	private $idCerca; //Int. Id de la cerca
	private $tipus; //String .Tipus de local
	private $superficieMinima; //Float. Superficies minima util que desitja el client
	private $dataInici; //Objecte Data. Data d'inici 
	private $dataFi; //Objecte Data. Data de fi 
	private $preu; //Float. Preu maxim del locals que desitja
	private $caracteristiques; //String. Caracteristiques que desitja el client
	private $zones; //Array de Zona. Zones de preferencia per el client
	private $locals; //Array de Local (els que coincideixen amb la cerca).

	function __construct($idCerca = "")
	{
		$this->setIdCerca($idCerca);
		if ($this->idCerca != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdCerca($idCerca)
	{
		$this->idCerca = $idCerca;
	}

	public function getIdCerca()
	{
		return $this->idCerca;
	}

	public function setTipus($tipus)
	{
		$this->tipus = $tipus;
	}

	public function getTipus()
	{
		return $this->tipus;
	}

	public function setSuperficieMinima($superficieMinima)
	{
		$this->superficieMinima = $superficieMinima;
	}

	public function getSuperficieMinima()
	{
		return $this->superficieMinima;
	}

	public function setDataInici(Data $dataInici)
	{
		$this->dataInici = $dataInici;
	}

	public function getDataInici()
	{
		return $this->dataInici;
	}

	public function setDataFi(Data $dataFi)
	{
		$this->dataFi = $dataFi;
	}

	public function getDataFi()
	{
		return $this->dataFi;
	}

	public function setPreu($preu)
	{
		$this->preu = $preu;
	}

	public function getPreu()
	{
		return $this->preu;
	}

	public function setCaracteristiques($caracteristiques)
	{
		$this->caracteristiques = $caracteristiques;
	}

	public function getCaracteristiques()
	{
		return $this->caracteristiques;
	}

	public function setZones($zones)
	{
		$this->zones = $zones;
	}

	public function getZones()
	{
		return $this->zones;
	}
	
	protected function setLocals($locals)
	{
		$this->locals = $locals;
	}
	
	public function getLocals()
	{
		return $this->locals;
	}
	
	public function guarda($compte)
	{
		global $bd;
		
		$idCompte = $compte->getIdCompte();
		
		//Insert a la taula cerques i obte el id que tindra la cerca
		$instruccio = "INSERT INTO cerques (superficie_minima, tipus, data_inici, data_fi, preu, caracteristiques) VALUES (".$this->superficieMinima.", '". $this->tipus."', '".$this->dataInici->getYYYYMMDD()."', '".$this->dataFi->getYYYYMMDD()."', ".$this->preu.", '".$this->caracteristiques."')";
		$resultat = $bd->consulta($instruccio);
		$this->idCerca = mysql_insert_id( $bd->connexio );
		
		//Insert a la taula cerques_zones
		foreach ($this->getZones() as $zona)
		{
			$id_zona = $zona->getIdZona();
			$instruccio = "INSERT INTO cerca_zona (id_cerca, id_zona) VALUES (".$this->idCerca.", ".$id_zona.")";
			$resultat = $bd->consulta($instruccio);
		}
						
		//Insert a la taula cerca_compte
		$instruccio = "INSERT INTO cerca_compte (id_cerca, id_compte) VALUES (".$this->idCerca.", ".$idCompte.")";
		$resultat = $bd->consulta($instruccio);
	}
		
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM cerques WHERE id_cerca = ".$this->idCerca;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->superficiesMinima = $row["superficie_minima"];
			
			$termes = explode("-", $row["data_inici"]);
			$dataInici = new Data(0);
			if (sizeof($termes) >= 3)
			{
				$dia = $termes[2];
				$mes = $termes[1];
				$any = $termes[0];
				$dataInici = new Data($dia, $mes, $any);
			}
			$this->dataInici = $dataInici;

			$termes = explode("-", $row["data_fi"]);
			$dataFi = new Data(0);
			if (sizeof($termes) >= 3)
			{
				$dia = $termes[2];
				$mes = $termes[1];
				$any = $termes[0];
				$dataFi = new Data($dia, $mes, $any);
			}
			$this->dataFi = $dataFi;
			
			$this->preu = $row["preu"];
			$this->caracteristiques = $row["caracteristiques"];
			$this->tipus = $row["tipus"];
			//$this->zones = $row[""];
		}
		$this->zones = Array();
		$this->carregaZones();
	}
	
	public function carregaZones()
	{
		global $bd;
		$instruccio = "SELECT id_zona FROM cerca_zona WHERE id_cerca = ".$this->idCerca;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->zones[] = new Zona($row["id_zona"]);
		}
	}
	
	public function seleccionaLocals($zones, $tipus, $superficie, $dataInici, $dataFi, $preu, $caracteristiques)
	{
		global $immobiliaria;
		
		$this->setZones($zones);
		$this->setTipus($tipus);
		$this->setSuperficieMinima($superficie);
		$this->setDataInici($dataInici);
		$this->setDataFi($dataFi);
		$this->setPreu($preu);
		$this->setCaracteristiques($caracteristiques);
		
		$locals = $immobiliaria->getLocals();
		
		$this->setLocals(Array());
		$localsCoincidents = Array();
		
		foreach ($locals as $local)
		{
			if ($local->coincideixCerca($this))
			{
				$localsCoincidents[] = local;
			}
		}
		
		$this->setLocals($localsCoincidents);
	}
	
	protected function creaDades()
	{
	}
	
	public function mostraInformacio()
	{
		$informacio = "Tipus: " . $this->tipus . ", Superf&iacute;cie m&iacute;nima: ".$this->superficieMinima."m<sup>2</sup>";
		$informacio .= ", Data d'inici: " . $this->getDataInici()->getYYYYMMDD();
		$informacio .= ", Data final: " . $this->getDataFi()->getYYYYMMDD();
		$informacio .= ", Preu: " . $this->preu . ", Caracter&iacute;stiques: " .$this->caracteristiques;
		$informacio .= ", Zones:";
		
		foreach ($this->zones as $zona)
		{
			$informacio .= " " . $zona->getDescripcio() . ", ";
		}
		
		$informacio = substr($informacio, 0, strlen($informacio) - 2);
		
		return $informacio;
	}
	
	public function mostra()
	{
		foreach ($this->getLocals() as $local)
		{
			$local->mostrar();
		}
	}
}//Fi Classe Cerca

class Telefon
{
	private $idTelefon; //int. Id del telefon
	private $telefon; //String. Numero de telefono
	
	function __construct($idTelefon = "")
	{
		$this->setIdTelefon($idTelefon);
		if ($this->idTelefon != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdTelefon($idTelefon)
	{
		$this->idTelefon = $idTelefon;
	}	
	
	public function getIdTelefon()
	{
		return $this->idTelefon;
	}
		
	public function setTelefon($telefon)
	{
		$this->telefon = $telefon;
	}	
	
	public function getTelefon()
	{
		return $this->telefon;
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT telefon FROM telefons WHERE id_telefon = ".$this->idTelefon;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->telefon = $row["telefon"];
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}
}
?>