<?php
	//Si s'ha enviat l'opcio de sortir de la sessio, surt:
	$get = getGet();
	if (isset($get["sortir"]) && trim($get["sortir"]) == "si")
	{
		destruirSession();
	}
	
	//Comprova si s'ha enviat una identificacio:
	$post = getPost();
	if (formulariIdentificacioEnviat($post) && formulariIdentificacioValid($post)) //Si cal, mostrara errors.
	{
		//Comprova si la identificacio enviada es correcta:
		formulariIdentificacioUsuariValid($post); //Si cal, mostrara errors.
	}
	
	//Si no esta identificat, mostra el formulari d'identificacio:
	if (!usuariIdentificat()) { formulariIdentificacioMostrar($post); }
	else { formulariIdentificacioMostrarSortir(); }


	//Funcio que retorna si el usuari esta identificat o no:
	function usuariIdentificat()
	{
		$session = getSession();
		return (isset($session["entitat_identificada"]));
	}

	//Funcio que mostra el formulari d'identificacio:
	function formulariIdentificacioMostrar($post)
	{
		$nomEnviat = "";
		if (isset($post["nom"])) { $nomEnviat = trim($post["nom"]); }
		?>
		<a href="registrarse.php?<?php echo sessioURL; ?>" class="login">Registrar-se</a>
		<br />
		<br />
		<form action="<?php echo arxiuActual; ?>" method="post" class="login" onSubmit="return validarFormulariIdentificacio();">
			<?php echo sessioForm; ?>
			<input type="hidden" name="identificacio" value="enviada">
			<table align="center" class="login">
				<tr>
					<td class="login">
						Usuari:
					</td>
					<td>
						<input type="text" name="nom" id="nom" value="<?php echo $nomEnviat; ?>" class="login_text">
					</td>
				</tr>
				<tr>
					<td class="login">
						Clau:
					</td>
					<td>
						<input type="password" name="clau" id="clau" value="" class="login_text">
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center">
						<input type="submit" name="boto" value="Identificar-se" class="login_boto">
					</td>
				</tr>
			</table>
		</form>
		<?php
	}
	
	//Funcio que mostra l'opcio de sortir:
	function formulariIdentificacioMostrarSortir()
	{
		$session = getSession();
		$nomUsuari = "";
		if (isset($session["entitat_identificada"]))
		{
			$entitat = $session["entitat_identificada"];
			$nomUsuari = " <span class=\"nom_usuari\">" . htmlentities($entitat->getCompte()->getNom()) . "</span>";
		}
		mostraMissatge("Benvingut$nomUsuari", 'Est&agrave;s identificat<br /><a href="' . arxiuActual . '?' . sessioURL . '&sortir=si" class="login">Sortir</a>');
	}
	
	//Funcio que retorna si s'ha enviat o no el formulari d'identificacio:
	function formulariIdentificacioEnviat($post)
	{
		return (isset($post["identificacio"]) && trim($post["identificacio"]) == "enviada");
	}
	
	//Funcio que retorna si el formulari d'identificacio es valid o no:
	function formulariIdentificacioValid($post)
	{
		$errors = "";
		
		//Comprova les dades:
		if (!isset($post["nom"]) || trim($post["nom"]) == "")
		{
			$errors .= "<br />S'ha de ficar un nom d'usuari";
		}
		if (!isset($post["clau"]) || trim($post["clau"]) == "")
		{
			$errors .= "<br />S'ha de ficar una clau";
		}
		
		//Si han hagut errors, mostra el missatge pertinent:
		if ($errors != "")
		{
			mostraError("Formulari incorrecte:", $errors . "<br /><br />");
		}
	
		//Retorna true o false segons les dades son valides o no:
		return ($errors == "");
	}
	
	//Funcio que retorna si el usuari identificat es correcte:
	function formulariIdentificacioUsuariValid($post)
	{
		global $bd;
		
		$totBe = TRUE;
		
		$nom = $post["nom"];
		$clau = $post["clau"];
		
		$instruccio = "SELECT * FROM comptes WHERE nom LIKE '$nom' AND clau LIKE '$clau'";
		$resultats = $bd->consulta($instruccio);
		
		//Si el usuari no esta identificat, mostra un error:
		if (mysql_num_rows($resultats) <= 0) 
		{ 
			mostraError("Usuari inexistent", "El nom i/o clau no son v&aacute;lids."); 
			$totBe = FALSE; 
		}
		//...pero si si ho esta:
		else
		{
			//Crea un objecte amb la seva identitat corresponent i el carrega a la sessio:
			$row = mysql_fetch_assoc($resultats);
			$idCompte = $row["id_compte"];
			$entitat = new Entitat();
			$entitat->obtenirIdEntitat($idCompte);
			setSession("entitat_identificada", $entitat);
		}
		
		return $totBe;
	}
?>