<?php
	//Impedeix l'acces si ja son usuaris registrats:
	$session = getSession();
	$nomUsuari = "";
	if (isset($session["entitat_identificada"]))
	{
		mostraError("Acc&egrave;s restringit", "Area per a usuaris no registrats.");
		return;
	}
	
	//Comprova si s'ha enviat una peticio de registre:
	$post = getPost();
	if (formulariRegistreEnviat($post) && formulariRegistreValid($post)) //Si cal, mostrara errors.
	{
		//Registra el compte enviat:
		if (registrarCompte($post)) //Si cal, mostrara errors.
		{
			setSession("registre_realitzat", TRUE); //Si tot ha anat be, defineix que ja s'ha fet un registre.
			//$registreRealitzat = TRUE;
		}
	}

	//Si mai s'ha realitzar un registre, mostra el formulari de registre:
	$session = getSession();
	if (!isset($session["registre_realitzat"]))
	{
		formulariRegistreMostrar($post);
	}
	else { registreFinalitzatMostrar(); }


	//Funcio que mostra el formulari de registre:
	function formulariRegistreMostrar($post)
	{
		$tipusEnviat = "";
		$nifEnviat = "";
		$nomEnviat = "";
		if (isset($post["tipus"])) { $tipusEnviat = trim($post["tipus"]); }
		if (isset($post["nif"])) { $nifEnviat = trim($post["nif"]); }
		if (isset($post["nom"])) { $nomEnviat = trim($post["nom"]); }
		?>
		<form action="<?php echo arxiuActual; ?>" method="post" class="registre" onSubmit="return validarFormulariRegistre();">
			<?php echo sessioForm; ?>
			<input type="hidden" name="registre" value="enviat">
			<table align="center" class="registre">
				<tr>
					<td class="registre">
						Tipus:
					</td>
					<td>
						<select name="tipus" id="tipus" class="registre_select">
							<?php
								$tipus = Array("persona" => "Persona", "empresa" => "Empresa");
								foreach ($tipus as $k => $v)
								{
									$selected = "";
									if ($k == $tipusEnviat) { $selected = " selected"; }
									echo "<option value=\"$k\"$selected>$v</option>";
								}
							?>
						</select>
					</td>
				</tr>
				<tr>
					<td class="registre">
						NIF:
					</td>
					<td>
						<input type="text" name="nif" id="nif" value="<?php echo $nifEnviat; ?>" class="registre_text">
					</td>
				</tr>
				<tr>
					<td class="registre">
						Usuari:
					</td>
					<td>
						<input type="text" name="nom" id="nom_registre" value="<?php echo $nomEnviat; ?>" class="registre_text">
					</td>
				</tr>
				<tr>
					<td class="registre">
						Clau:
					</td>
					<td>
						<input type="password" name="clau" id="clau_registre" value="" class="registre_text">
					</td>
				</tr>
				<tr>
					<td class="registre">
						Clau un altre cop:
					</td>
					<td>
						<input type="password" name="clau_repetida" id="clau_repetida" value="" class="registre_text">
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center">
						<input type="submit" name="boto" value="Identificar-se" class="registre_boto">
					</td>
				</tr>
			</table>
		</form>
		<?php
	}

	//Funcio que es mostra si ja s'ha enviat un registre:
	function registreFinalitzatMostrar()
	{
		mostraMissatge("Registre enviat", "Ja pots identificar-te");
	}

	//Funcio que retorna si s'ha enviat o no el formulari de registre:
	function formulariRegistreEnviat($post)
	{
		return (isset($post["registre"]) && trim($post["registre"]) == "enviat");
	}
	
	//Funcio que retorna si el formulari de registre es valid o no:
	function formulariRegistreValid($post)
	{
		$errors = "";
		
		//Comprova les dades:
		if (!isset($post["tipus"]) || trim($post["tipus"]) == "" || trim($post["tipus"]) != "persona" && trim($post["tipus"]) != "empresa")
		{
			$errors .= "<br />S'ha de ficar un tipus (persona o empresa)";
		}
		if (!isset($post["nif"]) || trim($post["nif"]) == "")
		{
			$errors .= "<br />S'ha de ficar un NIF";
		}
		if (!isset($post["nom"]) || trim($post["nom"]) == "")
		{
			$errors .= "<br />S'ha de ficar un nom d'usuari";
		}
		if (!isset($post["clau"]) || trim($post["clau"]) == "")
		{
			$errors .= "<br />S'ha de ficar una clau";
		}
		if (!isset($post["clau_repetida"]) || trim($post["clau_repetida"]) == "")
		{
			$errors .= "<br />S'ha de ficar la clau repetida";
		}
		if (isset($post["clau"]) && trim($post["clau"]) != "" && isset($post["clau_repetida"]) && trim($post["clau_repetida"]) != "" && $post["clau"] != $post["clau_repetida"])
		{
			$errors .= "<br />La clau no coincideix al repetir-se";
		}
		
		//Si han hagut errors, mostra el missatge pertinent:
		if ($errors != "")
		{
			mostraError("Formulari incorrecte:", $errors . "<br /><br />");
		}
	
		//Retorna true o false segons les dades son valides o no:
		return ($errors == "");
	}

	//Funcio que processa i efectua el registre:
	function registrarCompte($post)
	{
		global $bd;
		
		$totBe = TRUE;
	
		//Si ja s'ha enviat un registre, surt:
		$session = getSession();
		if (isset($session["registre_realitzat"])) { return FALSE; }

		//Recull les dades enviades:
		$tipusEnviat = "persona"; //S'asumeix per defecte que es una persona, si no s'ha enviat el tipus (cosa rara).
		$nifEnviat = "";
		$nomEnviat = "";
		$clauEnviada = "";
		$clauRepetidaEnviada = "";
		if (isset($post["tipus"])) { $tipusEnviat = trim($post["tipus"]); }
		if (isset($post["nif"])) { $nifEnviat = trim($post["nif"]); }
		if (isset($post["nom"])) { $nomEnviat = trim($post["nom"]); }
		if (isset($post["clau"])) { $clauEnviada = trim($post["clau"]); }
		if (isset($post["clau_repetida"])) { $clauRepetidaEnviada = trim($post["clau_repetida"]); }
		
		//Si l'usuari ja existeix, surt:
		if (existeixUsuari($nomEnviat))
		{
			mostraError("Usuari no perm&egrave;s", "L'usuari ja existeix");
			return false;
		}

		//Si encara no existeix una entitat amb aquest NIF, la crea:
		if (!existeixEntitatNIF($nifEnviat))
		{
			$instruccio1 = "INSERT INTO entitats (nif, tipus) VALUES ('$nifEnviat', '$tipusEnviat')";
			$totBe = $bd->consulta($instruccio1);
			$idEntitat = mysql_insert_id($bd->connexio);
		}
		//Si no, agafa el id de la entitat:
		else
		{
			$idEntitat = agafaIdEntitatNIF($nifEnviat);
		}
		
		//Si tot ha anat be, inserta el nou compte:
		if ($totBe)
		{
			//$idEntitat = mysql_insert_id($bd->connexio);
			$instruccio2 = "INSERT INTO comptes (id_entitat, nom, clau) VALUES ($idEntitat, '$nomEnviat', '$clauEnviada')";
			$totBe = $bd->consulta($instruccio2);
			
			//Si no s'ha pogut realitzar, elimina la entitat:
			if (!$totBe)
			{
				$instruccio = "DELETE FROM entitats WHERE id_entitat = " . $idEntitat;
				$bd->consulta($instruccio);
			}
		}
		
		//Si ha hagut algun error, informa:
		if (!$totBe)
		{
			mostraError("Error al registrar-se", "No s'ha pogut realitzar el registre. Disculpi les molesties.");
		}
		
		return $totBe;
	}
	
	//Retorna si un usuari ja existeix o no:
	function existeixUsuari($nom)
	{
		global $bd;
		$instruccio = "SELECT * FROM comptes WHERE nom LIKE '$nom'";
		$resultats = $bd->consulta($instruccio);
		return (mysql_num_rows($resultats) > 0);
	}
	
	//Retorna si una entitat ja existeix o no (amb el NIF donat):
	function existeixEntitatNIF($nif)
	{
		global $bd;
		$instruccio = "SELECT * FROM entitats WHERE nif LIKE '$nif'";
		$resultats = $bd->consulta($instruccio);
		return (mysql_num_rows($resultats) > 0);
	}
	
	//Retorna el id d'una entitat que conte el NIF donat:
	function agafaIdEntitatNIF($nif)
	{
		global $bd;
		$idEntitat = 0;
		$instruccio = "SELECT * FROM entitats WHERE nif LIKE '$nif'";
		$resultats = $bd->consulta($instruccio);
		if ($matriu = mysql_fetch_assoc($resultats))
		{
			$idEntitat = $matriu["id_entitat"];
		}
		return $idEntitat;
	}
?>