<?php
	//Inclou les classes necessaries:
	require_once "php/classes/entitats.php";
	require_once "php/classes/locals.php";
	require_once "php/classes/situacio.php";
	require_once "php/classes/general.php";
	
	//Inicia o continua la sessio:
	session_start();
	session_name("llogatot");

	//Inclou l'arxiu de configuracio:
	require_once "php/configuracio.php";
	
	//Inclou l'arxiu amb les funcions generals:
	require_once "php/general.php";

	//Inclou l'arxiu amb la classe de la base de dades:
	require_once "php/classes/bd.php";
	
	//Conecta a la base de dades:
	$bd = new bd();
	$bd->connecta();
	$bd->selecciona();

	//Crea el objecte principal, si no existeix ja en la sessio:
	$session = getSession();
	if (!isset($session["immobiliaria"]))
	{
		$immobiliaria = new Immobiliaria();
		setSession("immobiliaria", $immobiliaria);
	}
	else
	{
		$immobiliaria = $session["immobiliaria"];
	}


	//Si existeix algun estil guardat, el recupera:
	$estilArxiu = "estils.css";
	$cookie = getCookie();
	if (isset($cookie["estil"]) && trim($cookie["estil"]) != "")
	{
		$estilArxiu = trim($cookie["estil"]);
	}
	
	//Si s'ha enviat guardar els estils, els guarda:
	$get = getGet();
	$estilGuardat = FALSE;
	if (isset($get["guarda"]) && trim($get["guarda"]) != "")
	{
		$estilArxiu = trim($get["guarda"]);
		setCookie("estil", $estilArxiu);
		$estilGuardat = TRUE;
	}
?>
<html>
	<head>
		<title><?php echo nomEmpresa; ?></title>
		<link rel="stylesheet" href="css/<?php echo $estilArxiu; ?>" type="text/css" id="css">
		<script language="JavaScript" type="text/javascript" src="js/general.js"></script>
		<script language="JavaScript" type="text/javascript" src="js/estils.js"></script>
		<script language="JavaScript" type="text/javascript" src="js/formularis.js"></script>
		<script language="javascript" type="text/javascript" src="js/datetimepick/datetimepicker.js">
			//Date Time Picker script- by TengYong Ng of http://www.rainforestnet.com
			//Script featured on JavaScript Kit (http://www.javascriptkit.com)
			//For this script, visit http://www.javascriptkit.com
		</script>
	</head>
	<body onLoad="aplicarAspecte();">
		<center>
		<table align="center" class="logo">
			<tr>
				<td class="logo">
					<img src="img/logo_transparent.gif">
				</td>
			</tr>
		</table>
		<table align="center" class="estructura">
			<tr>
				<td class="menu">
					<?php
						include "php/inc/menu.php";
					?>
				</td>
				<td class="cos">
					<?php
						include "php/inc/cos.php";
					?>
				</td>
			</tr>
		</table>
		<table align="center" class="peu">
			<tr>
				<td class="peu">
					<?php
						include "php/inc/peu.php";
					?>
				</td>
			</tr>
		</table>
		</center>
	</body>
</html>
<?php
	//Desconecta de la base de dades:
	$bd->desconnecta();
?>