<?php
class Local
{
	private $idLocal; //int. Id del local
	private $adresa; //Adresa. 
	private $codiLocal; // String. Codi identificatiu del local
	private $tipus; //String. Tipus del local
	private $superficie; //Float. Superficie util del local
	private $caracteristiques; // String. Caracteristiques del local
	private $restriccions; //String. Restriccions del local
	private $actiu; //Boolean. Indica si el local esta donat d'alta
	private $propietari; // Propietari. Propietari del local
	private $contracte; //Contracte. Contracte que te el loca, pot no tenir contracte si no esta llogat
	
	function __construct($idLocal = "")
	{	
		$this->setIdLocal($idLocal);
		if ($this->idLocal != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdLocal($idLocal)
	{
		$this->idLocal = $idLocal;
	}
	
	public function getIdLocal()
	{
		return $this->idLocal;
	}

	public function setAdresa(Adresa $adresa)
	{
		$this->adresa = $adresa;
	}
	
	public function getAdresa()
	{
		return $this->adresa;
	}

	public function setCodiLocal($codiLocal)
	{
		$this->codiLocal = $codiLocal;
	}
	
	public function getCodiLocal()
	{
		return $this->codiLocal;
	}

	public function setTipus($tipus)
	{
		$this->tipus = $tipus;
	}
	
	public function getTipus()
	{
		return $this->tipus;
	}

	public function setSuperficie($superficie)
	{
		$this->superficie = $superficie;
	}
	
	public function getSuperficie()
	{
		return $this->superficie;
	}

	public function setCaracteristiques($caracteristiques)
	{
		$this->caracteristiques = $caracteristiques;
	}
	
	public function getCaracteristiques()
	{
		return $this->caracteristiques;
	}

	public function setActiu($actiu)
	{
		$this->actiu = $actiu;
	}

	public function getActiu()
	{
		return $this->actiu;
	}

	public function setPropietari(Propietari $propietari)
	{
		$this->propietari = $propietari;
	}

	public function getPropietari()
	{
		return $this->propietari;
	}

	public function mostra()
	{
	echo "
		<table>
			  <tr>
					<td>Tipus</td>
					<td>".$this->tipus."</td>
					<td>Superficie</td>
					<td>".$this->superficie."</td>
			  </tr>
			  <tr>
					<td>Preu</td>
					<td>".$this->preu."</td>
					<td>Codi</td>
					<td>".$this->codiLocal."</td>
			  </tr>
			  <tr>
					<td>Adre&ccedil;a</td>
					<td colspan='3'>".$this->adresa."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques</td>
					<td colspan='3'>".$this->caracteristiques."</td>
			  </tr>
			  <tr>
					<td>Restriccions</td>
					<td colspan='3'>".$this->restriccions."</td>
			  </tr>
		</table> ";
	}
	
	public function mostraEspecial()
	{	
		global $bd;
				
		if ($this->tipus == "oficina")
		{
			$instruccio = "SELECT id_oficina FROM oficines WHERE id_local = ".$this->idLocal;
			$resultat = $bd->consulta($instruccio);
			$row = mysql_fetch_assoc($resultat);
			$oficina = new Oficina($row["id_oficina"]);
			$oficina->mostra();
		}
		
		if ($this->tipus == "botiga_magatzem")
		{
			$instruccio = "SELECT id_botiga_magatzem FROM botigues_magtzem WHERE id_local = ".$this->idLocal;
			$resultat = $bd->consulta($instruccio);
			$row = mysql_fetch_assoc($resultat);
			$botigaMagatzem = new BotigaMagatzem($row["id_botiga_magatzem"]);
			$BotigaMagatzem->mostra();
		}
		
		if ($this->tipus == "immoble")
		{
			$instruccio = "SELECT id_immoble FROM immobles WHERE id_local = ".$this->idLocal;
			$resultat = $bd->consulta($instruccio);
			$row = mysql_fetch_assoc($resultat);
			$immoble = new Immoble($row["id_immoble"]);
			$immoble->mostra();
		}
		
		if ($this->tipus == "polivalent")
		{
			$instruccio = "SELECT id_polivalent FROM polivalents WHERE id_local = ".$this->idLocal;
			$resultat = $bd->consulta($instruccio);
			$row = mysql_fetch_assoc($resultat);
			$polivalent = new Polivalent($row["id_polivalent"]);
			$polivalent->mostra();
		}
	}
		
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function esBotigaMagatzem()
	{
		if($this->tipus == "botiga_magatzem")
			return true;
		else
			return false;
	}
	
	public function esPolivalent()
	{
		if($this->tipus == "polivalent")
			return true;
		else
			return false;
	}
	
	public function esOficina()
	{
		if($this->tipus == "oficina")
			return true;
		else
			return false;
	}
	
	public function esImmoble()
	{
		if($this->tipus == "immoble")
			return true;
		else
			return false;
	}
	
	public function coincideixCerca(Cerca $cerca)
	{
		global $immobiliaria;
		
		$locals = $immobiliaria->getLocals();
		$localCoincidents = Array();

		foreach ($locals as $local) 
		{
		   if ($cerca->tipus == "tots" || $this->tipus == $cerca->tipus )
		   	{
				//Select per obtenir les dates del contracte si el local esta lligat a un contracte
				$instruccio = "SELECT data_inici, data_fi FROM contractes WHERE id_local = ".$local->getIdLocal();
				$resultat = $bd->consulta($instruccio);
				$row = mysql_fetch_assoc($resultat);
				
				if ($row != null)
				{
					$dataIniciLloguer = new Data($cerca->getDataInici());
					$dataFiLloguer = new Data($cerca->getDataFi());
					$dataIniciContracte = new Data($row["data_inici"]);
					$dataFiContracte = new Data($row["data_fi"]);
					
					if ( $dataIniciLloguer->peridodesColisiones($dataIniciLloguer, $dataFiLloguer, $dataIniciContracte, $dataFiContracte) )
						if ($this->superficie >= $cerca->superficieMinima)
							if ($this->preu <= $cerca->preu)
								if($this->caracteristiques == $cerca->caracteristiques)
								{
									foreach ($cerca->zones as $zona) 
									{
										if($this->zona == $zona)
											return true;
									}
								}
				}
			}
		}
		return false;
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM locals WHERE id_local = ".$this->idLocal;
		$resultat = $bd->consulta($instruccio);
		while($row = mysql_fetch_assoc($resultat))
		{
			$this->adresa = new Adresa($row["id_adresa"]);
			$this->codiLocal = $row["codi_local"];
			$this->tipus = $row["tipus"];
			$this->superficie = $row["superficie"];
			$this->caracteristiques = $row["caracteristiques"];
			$this->restriccions = $row["restriccions"];
			$this->actiu = $row["actiu"];
			$this->propietari = new Propietari($row["id_propietari"]);
		}
		$this->carregaContracte();
	}
	
	public function carregaContracte()
	{
		global $bd;
		$instruccio = "SELECT id_contracte FROM contractes WHERE id_local = ".$this->idLocal;
		$resultat = $bd->consulta($instruccio);
		$row = mysql_fetch_assoc($resultat);
		$this->contracte = new Contracte($row["id_contracte"]);
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}
	
}//Fi Classe Local

class BotigaMagatzem extends Local
{
	private $idBotigaMagatzem; //Int. Id de la botiga-magatzem
	private $volum; //Float. Volum del que disposa la botiga-magatzem
	
	function __construct($idBotigaMagatzem = "")
	{
		$this->setIdAdresa($idBotigaMagatzem);
		if ($this->idBotigaMagatzem != "")
		{
			$this->carregaDades();
		}
	}
	
	protected function setIdBotigaMagatzem($idBotigaMagatzem)
	{
		$this->idBotigaMagatzem = $idBotigaMagatzem;
	}
	
	public function getIdBotigaMagatzem()
	{
		return $this->idBotigaMagatzem;
	}

	public function setVolum($volum)
	{
		$this->volum = $volum;
	}

	public function getVolum()
	{
		return $this->volum;
	}
	
	public function mostra()
	{
	echo "
		<table>
			  <tr>
					<td>Tipus</td>
					<td>".parent::getTipus()."</td>
					<td>Superficie</td>
					<td>".parent::getSuperficie()."</td>
			  </tr>
			  <tr>
					<td>Preu</td>
					<td>".parent::getPreu()."</td>
					<td>Codi</td>
					<td>".parent::getCodiLocal()."</td>
			  </tr>
			  <tr>
					<td>Volum</td>
					<td colspan='3'>".$this->volum()."</td>
			  </tr>
			  <tr>
					<td>Adre&ccedil;a</td>
					<td colspan='3'>".parent::getAdresa()."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques</td>
					<td colspan='3'>".parent::getCaracteristiques()."</td>
			  </tr>
			  <tr>
					<td>Restriccions</td>
					<td colspan='3'>".parent::getRestriccions()."</td>
			  </tr>
		</table> ";
	}
		
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM botigues_magatzem WHERE id_botiga_magatzem = ".$this->idBotigaMagatzem;
		$resultat = $bd->consulta($instruccio);
		while($row = mysql_fetch_assoc($resultat))
		{
			$this->volum = $row["volum"];
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}
}//Fi Clase Botiga-Magatzem

class Oficina extends Local
{
	private $idOficina; //Int. Identificador de l'oficina;
	
	function __construct($idOficina = "")
	{
		$this->setIdAdresa($idOficina);
	}
	
	protected function setIdOficina($idOficina)
	{
		$this->idOficina = $idOficina;
	}
	
	public function getIdOficina()
	{
		return $this->idOficina;
	}
	
	public function mostra()
	{
	echo "
		<table>
			  <tr>
					<td>Tipus</td>
					<td>".parent::getTipus."</td>
					<td>Superficie</td>
					<td>".parent::getSuperficie."</td>
			  </tr>
			  <tr>
					<td>Preu</td>
					<td>".parent::getPreu."</td>
					<td>Codi</td>
					<td>".parent::getCodiLocal."</td>
			  </tr>
			  <tr>
					<td>Adre&ccedil;a</td>
					<td colspan='3'>".parent::getAdresa."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques</td>
					<td colspan='3'>".parent::getCaracteristiques."</td>
			  </tr>
			  <tr>
					<td>Restriccions</td>
					<td colspan='3'>".parent::getRestriccions."</td>
			  </tr>
		</table> ";
	}
	
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{/*SELECT de totes les dades a partir del idAdrea*/
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}
}//Fi Clase Oficina

class Polivalent extends Local
{
	private $idPolivalent; //Int. Identificador del local polivalent
	private $caracteristiquesPolivalents; //String. Caracteristiques del local polivalent
	
	function __construct($idPolivalent = "")
	{
		$this->setIdPolivalent($idPolivalent);
		if ($this->idPolivalent != "")
		{
			$this->carregaDades();
		}		
	}
	
	protected function setIdPolivalent($idPolivalent)
	{
		$this->idPolivalent = $idPolivalent;
	}
	
	public function getIdPolivalent()
	{
		return $this->idPolivalent;
	}

	public function setCaracteristiquesPolivalent($caracteristiquesPolivalent)
	{
		$this->caracteristiquesPolivalent = $caracteristiquesPolivalent;
	}

	public function getCaracteristiquesPolivalent()
	{
		return $this->caracteristiquesPolivalent;
	}
	
	public function mostra()
	{
			echo "
		<table>
			  <tr>
					<td>Tipus</td>
					<td>".parent::getTipus."</td>
					<td>Superficie</td>
					<td>".parent::getSuperficie."</td>
			  </tr>
			  <tr>
					<td>Preu</td>
					<td>".parent::getPreu."</td>
					<td>Codi</td>
					<td>".parent::getCodiLocal."</td>
			  </tr>
			  <tr>
					<td>Adre&ccedil;a</td>
					<td colspan='3'>".parent::getAdresa."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques</td>
					<td colspan='3'>".parent::getCaracteristiques."</td>
			  </tr>
			  <tr>
					<td>Restriccions</td>
					<td colspan='3'>".parent::getRestriccions."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques Polivalents</td>
					<td colspan='3'>".$this->caracteristiquesPolivalents."</td>
			  </tr>
		</table> ";
	}
		
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		global $bd;
		$instruccio = "SELECT * FROM polivalents WHERE id_polivalent = ".$this->idPolivalent;
;		$resultat = $bd->consulta($instruccio);
		while($row = mysql_fetch_assoc($resultat))
		{
			$this->caracteristiquesPolivalents = $row["caracteristiques_polivalent"];		
		}
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}
}//Fi Clase Polivalent

class Immoble extends Local
{
	private $idImmoble; //Int. Identificador del immoble
	private $botiguesMagatzem; //Array de locals botigues-magatzem,
	private $oficines;// Array de locals oficines
	private $polivalents;//Array de locals polivalents
	
	function __construct($idImmoble = "")
	{
		$this->setIdAdresa($idImmoble);
		if ($this->idImmoble != "")
		{
			$this->carregaDades();
		}		
	}
	
	protected function setIdImmoble($idImmoble)
	{
		$this->idImmoble = $idImmoble;
	}
	
	public function getIdImmoble()
	{
		return $this->idImmoble;
	}

	public function setBotiguesMagatzem($botiguesMagatzem)
	{
		$this->botiguesMagatzem = $botiguesMagatzem;
	}

	public function getBotiguesMagatzem()
	{
		return $this->botiguesMagatzem;
	}

	public function setOficines($oficines)
	{
		$this->oficines = $oficines;
	}

	public function getOficines()
	{
		return $this->oficines;
	}

	public function setPolivalents($polivalents)
	{
		$this->polivalents = $polivalents;
	}

	public function getPolivalents()
	{
		return $this->polivalents;
	}

	public function mostraLocals()
	{
		foreach ($this->botiguesMagatzem as $botigaMagatzem) {
		   $botigaMagatzem->mostra();
		}
		foreach ($this->oficines as $oficina) {
		   $boficina->mostra();
		}
		foreach ($this->polivalents as $polivalents) {
		   $polivalents->mostra();
		}
	}

	public function mostra()
	{
		echo "
		<table>
			  <tr>
					<td>Tipus</td>
					<td>".parent::getTipus."</td>
					<td>Superficie</td>
					<td>".parent::getSuperficie."</td>
			  </tr>
			  ";
			  if (parent::getPreu() == "")
			  {
				echo "
				<tr>
					<td colspan='2'>Veure Locals</td>
				";
			  }
			  else
			  { 
				  echo "
				  <tr>
					<td>Preu</td>
					<td>".parent::getPreu."</td>
					";
			  }
			  echo "
					<td>Codi</td>
					<td>".parent::getCodiLocal."</td>
			  </tr>
			  <tr>
					<td>Adre&ccedil;a</td>
					<td colspan='3'>".parent::getAdresa."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques</td>
					<td colspan='3'>".parent::getCaracteristiques."</td>
			  </tr>
			  <tr>
					<td>Restriccions</td>
					<td colspan='3'>".parent::getRestriccions."</td>
			  </tr>
			  <tr>
					<td>Caracteristiques Polivalents</td>
					<td colspan='3'>".$this->caracteristiquesPolivalents."</td>
			  </tr>
		</table> ";
	}
		
	public function guarda()
	{/*INSERT o UPDATE de tots els atributs a la BD	
	*/
	}
	
	public function carregaDades()
	{
		$this->botiguesMagatzem = Array();
		$this->oficines = Array();
		$this->polivalents = Array();
		
		$this->carregaBotiguesMagatzem();
		$this->carregaOficines();
		$this->carregaPolivalents();
	}
	
	private function carregaBotiguesMagatzem()
	{
		global $bd;
		$instruccio = "SELECT id_botiga_magatzem FROM immoble_botiga_magatzem WHERE id_immoble = ".$this->idImmoble;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->botiguesMagatzem[] = new BotigaMagatzem($row["id_botiga_magatzem"]);
		}
	}
	
	private function carregaOficines()
	{
		global $bd;
		$instruccio = "SELECT id_oficina FROM immoble_oficina WHERE id_immoble = ".$this->idImmoble;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->oficines[] = new Oficina($row["id_oficina"]);
		}
	}
	
	private function carregaPolivalents()
	{
		global $bd;
		$instruccio = "SELECT id_polivalent FROM immoble_polivalent WHERE id_immoble = ".$this->idImmoble;
		$resultat = $bd->consulta($instruccio);
		while ($row = mysql_fetch_assoc($resultat))
		{
			$this->polivalents[] = new Polivalent($row["id_polivalent"]);
		}		
	}
	
	protected function creaDades()
	{/*INSERT a la base de dades
	  *s'agafara el id_adresa de la BD
	  */
	}
}//Fi Clase Immoble
?>