<?php
	//Mostra un error amb els estils adequats:
	function mostraError($errorTitol, $errorText, $errorNumero = 0)
	{
		global $errors;
		if ($errorNumero > 0 && $errorNumero < sizeof($errors)) { $errorTitol = $errors[$errorNumero]; }
		echo '<span class="error_titol">' . $errorTitol . '</span><br /><span class="error_text">' . $errorText . "</span>";
	}

	//Mostra un missatge amb els estils adequats:
	function mostraMissatge($missatgeTitol, $missatgeText)
	{
		echo '<span class="missatge_titol">' . $missatgeTitol . '</span><br /><span class="missatge_text">' . $missatgeText . "</span>";
	}

	//Retorna l'array amb els elements enviats per post:
	function getPost()
	{
		if (isset($HTTP_POST_VARS)) { $post = $HTTP_POST_VARS; }
		else if (isset($_POST)) { $post = $_POST; }
		
		if (!isset($post) || !is_array($post)) { $post = Array(); }
		
		return $post;
	}
	
	//Retorna l'array amb els elements enviats per get:
	function getGet()
	{
		if (isset($HTTP_GET_VARS)) { $get = $HTTP_GET_VARS; }
		else if (isset($_GET)) { $get = $_GET; }
		
		if (!isset($get) || !is_array($get)) { $get = Array(); }
		
		return $get;
	}

	//Retorna l'array amb els elements existents a les cookies:
	function getCookie()
	{
		if (isset($HTTP_COOKIE_VARS)) { $cookie = $HTTP_COOKIE_VARS; }
		else if (isset($_COOKIE)) { $cookie = $_COOKIE; }
		
		if (!isset($cookie) || !is_array($cookie)) { $cookie = Array(); }
		
		return $cookie;
	}
	
	//Destrueix la sessio actual i esborra totes les variables guardades en aquesta:
	function destruirSession()
	{
		session_destroy();
		if (isset($HTTP_SESSION_VARS)) { $HTTP_SESSION_VARS = Array(); }
		else if (isset($_SESSION)) { $_SESSION = Array(); }
	}
	
	//Funcio que fica una variable o matriu de sessio:
	function setSession($nom, $valor)
	{
		global $HTTP_SESSION_VARS;
		
		if (isset($HTTP_SESSION_VARS)) { $HTTP_SESSION_VARS[$nom] = $valor; }
		else if (isset($_SESSION)) { $_SESSION[$nom] = $valor; }
		else { $$nom = $valor; }
	}

	//Funcio que retorna la matriu amb la sessio:
	function getSession()
	{
		global $HTTP_SESSION_VARS;
		
		if (isset($HTTP_SESSION_VARS)) { $session = $HTTP_SESSION_VARS; }
		else if (isset($_SESSION)) { $session = $_SESSION; }
		else { $session = Array(); } //Matriu buida.

		return $session;
	}

	//Funcio que retorna si una adrea es d'E-Mail o no:
	function esEmail($conta)
	{
		return eregi("^[a-z]+[_\.\-]{0,1}[a-z0-9]+@[a-z0-9]+[_\.\-]{0,1}[a-z0-9]+\.[a-z]{2,4}$", $conta);
	}

?>