<?php
	//Impedeix l'acces si no son usuaris no registrats:
	$session = getSession();
	$nomUsuari = "";
	if (!isset($session["entitat_identificada"]))
	{
		mostraError("Acc&egrave;s restringit", "Area per a usuaris registrats.");
		return;
	}

	//Si s'ha enviat eliminar una cerca, la elimina:
	$post = getPost();
	if (esVolEsborrarCerca($post))
	{
		esborrarCerca($post);
		$session = getSession();
		echo '<br /><br />';
	}

	//Mostra les cerques:
	$entitat = $session["entitat_identificada"];
	mostraCerques($entitat);
	
	//Funcio que mostra les ultimes 10 cerques:
	function mostraCerques($entitat)
	{
		$cerquesFicades = 0;
		$cerques = $entitat->getCompte()->getCerques();
		foreach ($cerques as $cerca)
		{
			$id_cerca = $cerca->getIdCerca();
			$informacio_cerca = $cerca->mostraInformacio();
			//echo '<a href="' . arxiuActual . '?id_cerca=' . $id_cerca . '" class="cos">' . $informacio_cerca . "</a><br /><br />";
			
			echo '<table align="center" class="cercar"><tr>';
			echo "<td>$informacio_cerca</td>";
			echo "<td>";
			formulariVeureCercaMostrar($cerca);
			echo "</td>";
			echo "<td>";
			formulariModificarCercaMostrar($cerca);
			echo "</td>";
			echo "<td>";
			formulariEsborrarCercaMostrar($cerca);
			echo "</td>";
			echo "</tr></table>";
			
			$cerquesFicades++;
			if ($cerquesFicades >= 10) { break; } //Si ja ha ficat 10 cerques, surt.
		}
	}
	

	//Funcio que mostra el formulari de veure una cerca enviada per parametre:
	function formulariVeureCercaMostrar($cerca)
	{
		?>
		<form action="<?php echo arxiuActual; ?>" method="post" class="cercar">
			<?php echo sessioForm; ?>
			<input type="hidden" name="veure" value="si">
			<input type="hidden" name="id_cerca" value="<?php echo $cerca->getIdCerca(); ?>">
			<table align="center" class="cercar">
				<tr>
					<td class="cercar" align="right">
						<input type="submit" name="boto" value="Veure" class="cercar_emmagatzemada_boto">
					</td>
				</tr>
			</table>
		</form>
		<?php
	}

	//Funcio que mostra el formulari d'esborrar una cerca enviada per parametre:
	function formulariModificarCercaMostrar($cerca)
	{
		?>
		<form action="<?php echo arxiuActual; ?>" method="post" class="cercar">
			<?php echo sessioForm; ?>
			<input type="hidden" name="modificar" value="si">
			<input type="hidden" name="id_cerca" value="<?php echo $cerca->getIdCerca(); ?>">
			<table align="center" class="cercar">
				<tr>
					<td class="cercar" align="right">
						<input type="submit" name="boto" value="Modificar" class="cercar_emmagatzemada_boto">
					</td>
				</tr>
			</table>
		</form>
		<?php
	}
	
	//Funcio que mostra el formulari d'esborrar una cerca enviada per parametre:
	function formulariEsborrarCercaMostrar($cerca)
	{
		?>
		<form action="<?php echo arxiuActual; ?>" method="post" class="cercar" onSubmit="return confirmarEsborrarCerca();">
			<?php echo sessioForm; ?>
			<input type="hidden" name="esborrar" value="si">
			<input type="hidden" name="id_cerca" value="<?php echo $cerca->getIdCerca(); ?>">
			<table align="center" class="cercar">
				<tr>
					<td class="cercar" align="right">
						<input type="submit" name="boto" value="Esborrar" class="cercar_emmagatzemada_boto">
					</td>
				</tr>
			</table>
		</form>
		<?php
	}
	
	//Funcio que retorna si s'ha enviat eliminar una cerca o no:
	function esVolEsborrarCerca($post)
	{
		return (isset($post["esborrar"]) && trim($post["esborrar"]) == "si" && isset($post["id_cerca"]) && is_numeric(trim($post["id_cerca"])));
	}
	
	//Funcio que esborra una cerca:
	function esborrarCerca($post)
	{
		$idCerca = trim($post["id_cerca"]);
		
		$cerca = new Cerca($idCerca);
		if ($cerca->esborra())
		{
			mostraMissatge("Cerca esborrada", "La cerca ha estat esborrada correctament");
			
			//Actualitza la entitat que esta en la sessio:
			$session = getSession();
			$entitat = $session["entitat_identificada"];
			$entitat = new Entitat($entitat->getIdentitat());
			setSession("entitat_identificada", $entitat);
		}
		else
		{
			mostraError("Impossible esborrar cerca", "La cerca no s'ha pogut esborrar correctament. Disculpi les molesties.");
		}
	}
?>