CREATE TABLE usuaris
(
    id INT PRIMARY KEY AUTO_INCREMENT,
    nom VARCHAR (25) UNIQUE NOT NULL,
    clau VARCHAR (25) NOT NULL,
    tipus ENUM ('agent', 'inspector', 'venedor')
);

CREATE TABLE zones
(
    id INT PRIMARY KEY AUTO_INCREMENT,
    zona VARCHAR(4) NOT NULL UNIQUE,
    descripcio VARCHAR (25) NOT NULL UNIQUE
);

CREATE TABLE clients
(
    id INT PRIMARY KEY AUTO_INCREMENT,
    nif VARCHAR (11) UNIQUE NOT NULL,
    nom_o_rao_social VARCHAR (25) NOT NULL,
    cognoms VARCHAR (25) DEFAULT '',
    telefon VARCHAR (20) DEFAULT '',
    adresa VARCHAR (200) DEFAULT '',
    es_llogater BOOL,
    es_propietari BOOL,
    tipus ENUM ('persona', 'empresa'),
    preferencies_tipus_local ENUM ('oficina', 'botiga_magatzem', 'polivalent', 'immoble'),
    preferencies_id_zona INT,
    preferencies_superficie_minima DECIMAL (10,2) DEFAULT 0
);

CREATE TABLE locals
(
    id INT PRIMARY KEY AUTO_INCREMENT,
    id_propietari INT NOT NULL,
    codi_local VARCHAR (10) UNIQUE,
    actiu BOOL NOT NULL DEFAULT 0,
    id_zona INT NOT NULL,
    adresa VARCHAR (200) NOT NULL,
    restriccions TEXT DEFAULT '',
    caracteristiques TEXT DEFAULT '',
    caracteristiques_polivalent TEXT DEFAULT '',
    superficie DECIMAL (10,2) DEFAULT 0,
    volum DECIMAL (10,2) DEFAULT 0,
    preu DECIMAL (15,2) DEFAULT 0,
    tipus ENUM ('oficina', 'botiga_magatzem', 'polivalent', 'immoble') NOT NULL,
    UNIQUE KEY (id_zona, adresa)
);

CREATE TABLE immoble_local
(
    id_immoble INT,
    id_local INT,
    PRIMARY KEY (id_immoble, id_local)
);

CREATE TABLE contractes
(
    id_contracte INT PRIMARY KEY AUTO_INCREMENT,
    id_local INT,
    id_client INT,
    data_inici DATE,
    data_fi DATE,
    UNIQUE KEY (id_local, id_client)
);


INSERT INTO usuaris (id, nom, clau, tipus) VALUES ('', 'agent', 'a', 'agent'), ('', 'inspector', 'i', 'inspector'), ('', 'venedor', 'v', 'venedor');
INSERT INTO zones (id, zona, descripcio) VALUES ('', 'RESU', 'Reus Sud'), ('', 'REES', 'Reus Est'), ('', 'RENO', 'Reus Nord'), ('', 'REOE', 'Reus Oest'), ('', 'RECE', 'Reus Centre');
