using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;

using MySql.Data.MySqlClient;
using MySql.Data.Types;

using System.Data;

namespace BaseDatosNamespace
{
    public class BD
    {
        protected String usuario; //Usuario de la base de datos.
        protected String clave; //Clave de la base de datos.
        protected String host; //Host de la base de datos.
        protected String baseDatos; //Nombre de la base de datos.

        protected bool conectado = false; //Define si esta conectado o no a la base de datos.

        protected MySqlConnection dataConnection = null; //Guarda la conexion a la base de datos.
        public MySqlDataReader dataReader = null; //Guarda el DataReader de la ultima consulta ejecutada.

        public MySqlDataAdapter dataAdapter = null; //Guarda el DataAdapter de la ultima consulta ejecutada.
        public DataSet dataSet = null; //Guarda el DataSet de la ultima consulta ejecutada (asociado al DataAdapter).

        protected Int64 scalar = -1; //Guarda el valor escalar de la ultima consulta ejecutada.


        public BD()
        {
        }

        public BD(String usuario, String clave, String host, String baseDatos)
        {
            this.setUsuario(usuario);
            this.setClave(clave);
            this.setHost(host);
            this.setBaseDatos(baseDatos);
        }

        public void setUsuario(String usuario)
        {
            this.usuario = usuario;
        }

        public String getUsuario()
        {
            return this.usuario;
        }

        public void setClave(String clave)
        {
            this.clave = clave;
        }

        public String getClave()
        {
            return this.clave;
        }

        public void setHost(String host)
        {
            this.host = host;
        }

        public String getHost()
        {
            return this.host;
        }

        public void setBaseDatos(String baseDatos)
        {
            this.baseDatos = baseDatos;
        }

        public String getBaseDatos()
        {
            return this.baseDatos;
        }

        public void setDataConnection(MySqlConnection dataConnection)
        {
            this.dataConnection = dataConnection;
        }

        public MySqlConnection getDataConnection()
        {
            return this.dataConnection;
        }

        public void setDataReader(MySqlDataReader dataReader)
        {
            this.dataReader = dataReader;
        }

        public MySqlDataReader getDataReader()
        {
            return this.dataReader;
        }

        public void setDataSet(DataSet dataSet)
        {
            this.dataSet = dataSet;
        }

        public DataSet getDataSet()
        {
            return this.dataSet;
        }

        public void setScalar(Int64 scalar)
        {
            this.scalar = scalar;
        }

        public Int64 getScalar()
        {
            return this.scalar;
        }

        public bool getConectado()
        {
            return this.conectado;
        }

        //Conecta a la base de datos:
        public Boolean conecta() //Para una mejora, faltaria implementar lo del boolean.
        {
            Boolean totBe = true;

            //Si esta conectado, desconecta:
            if (this.getConectado()) { this.desconecta(); }

            //Guarda la conexion:
            this.setDataConnection(new MySqlConnection("datasource=" + host + ";database=" + baseDatos + ";uid=" + usuario + ";password=" + clave));

            //Abre la conexion:
            this.getDataConnection().Open();

            //Define como que esta conectado:
            this.conectado = true;

            return totBe;
        }

        //Desconecta a la base de datos:
        public bool desconecta() //Para una mejora, faltaria implementar lo del boolean.
        {
            Boolean totBe = true;

            //Si esta conectado, desconecta:
            if (!this.getConectado()) { return false; }

            //Si existe, cierra el DataReader:
            if (this.getDataReader() != null) { this.getDataReader().Close(); }

            //Si existe, cierra la conexion:
            if (this.getDataConnection() != null) { this.getDataConnection().Close(); }

            return totBe;
        }

        //Hace una consulta (devuelve un DataReader):
        public MySqlDataReader consulta(String instruccion)
        {
            //Si no esta conectado, sale retornando null:
            if (!this.getConectado()) { return null; }

            //Si existe un DataReader previo, lo cierra:
            if (this.getDataReader() != null) { this.getDataReader().Close(); } //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!

            //Ejecuta el comando enviado:
            MySqlCommand dataCommand = new MySqlCommand();
            dataCommand.Connection = this.getDataConnection();
            dataCommand.CommandText = instruccion;

            //Guarda el DataReader conseguido:
            this.setDataReader(dataCommand.ExecuteReader());

            //Devuelve el DataReader conseguido:
            return this.getDataReader();
        }

        //Hace una consulta (devuelve un DataReader):
        public MySqlDataReader consultaDataReader(String instruccion)
        {
            return this.consulta(instruccion);
        }

        //Hace una consulta normal (devuelve un valor escalar):
        public Int64 consultaScalar(String instruccion)
        {
            //Si no esta conectado, sale retornando -1:
            if (!this.getConectado()) { return -1; }

            //Si existe un DataReader previo, lo cierra:
            if (this.getDataReader() != null) { this.getDataReader().Close(); } //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!

            //Ejecuta en comando enviado:
            MySqlCommand dataCommand = new MySqlCommand();
            dataCommand.Connection = this.getDataConnection();
            dataCommand.CommandText = instruccion;

            //Guarda el escalar conseguido:
            this.setScalar((Int64)dataCommand.ExecuteScalar());

            //Devuelve el escalar conseguido:
            return this.getScalar();
        }

        //Hace una consulta normal (devuelve un DataSet):
        public DataSet consultaDataSet(String instruccion)
        {
            //Si no esta conectado, sale retornando null:
            if (!this.getConectado()) { return null; }

            //Si existe un DataReader previo, lo cierra:
            if (this.getDataReader() != null) { this.getDataReader().Close(); } //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!

            //Ejecuta el comando enviado:
            DataSet dataSet = new DataSet();
            MySqlDataAdapter dataAdapter = new MySqlDataAdapter(instruccion, this.getDataConnection());

            //Asocia el DataAdapter conseguido con el DataSet creado:
            dataAdapter.Fill(dataSet, "miDataSet");

            //Guarda el DataAdapter conseguido:
            this.dataAdapter = dataAdapter;

            //Guarda el DataSet conseguido:
            this.setDataSet(dataSet);

            //Devuelve el DataSet conseguido:
            return dataSet;
        }

        public DataSet consultaDataSetMultiple(String instruccion)
        {
            //Si no esta conectado, sale retornando null:
            if (!this.getConectado()) { return null; }

            //Si existe un DataReader previo, lo cierra:
            if (this.getDataReader() != null) { this.getDataReader().Close(); } //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!

            //Ejecuta el comando enviado:
            DataSet dataSet = new DataSet();
            MySqlDataAdapter dataAdapter = new MySqlDataAdapter(instruccion, this.getDataConnection());

            //Asocia el DataAdapter conseguido con el DataSet creado:
            dataAdapter.Fill(dataSet, "miDataSet");

            //Guarda el DataAdapter conseguido:
            this.dataAdapter = dataAdapter;

            //Guarda el DataSet conseguido:
            this.setDataSet(dataSet);

            //Devuelve el DataSet conseguido:
            return dataSet;
        }

        //Hace una consulta modificacion (devuelve las filas afectadas):
        public int modificacion(String instruccion)
        {
            int filasAfectadas = 0;

            //Si no esta conectado, sale retornando 0:
            if (!this.getConectado()) { return 0; }

            //Ejecuta el comando enviado:
            MySqlCommand dataCommand = new MySqlCommand();
            dataCommand.Connection = this.getDataConnection();
            dataCommand.CommandText = instruccion;

            //Guarda las filas afectadas:
            filasAfectadas = dataCommand.ExecuteNonQuery();

            //Devuelve las filas afectadas:
            return filasAfectadas;
        }

        //Recoge un DataReader y devuelve un string con su informacion:
        public String dataReaderToString(MySqlDataReader dataReader)
        {
            String campo;
            String cadena = "";

            //Recorre el DataReader:
            while (dataReader != null && dataReader.Read()) //FALTA: poner nombre de columnas arriba, antes que los campos.
            {
                campo = "";
                for (int x = 0; x < dataReader.FieldCount; x++) //Falta.
                {
                    campo = "[" + dataReader.GetString(x) + "]";
                    cadena += campo;
                }
                cadena += "\n";
            }

            //Retorna la cadena generada:
            return cadena;
        }

        //Devuelve una cadena con la informacion del DataReader de la ultima consulta:
        public String toString()
        {
            return this.dataReaderToString(this.getDataReader()); //Si no hay DataReader o este no contiene nada, devuelve una cadena vacia.
        }
    }
}
