using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using BaseDatosNamespace;

using MySql.Data.MySqlClient;
using MySql.Data.Types;

namespace LlogaTotGestio
{
    public partial class FormGestio : Form
    {
        public String sentencia;

        public FormGestio()
        {
            InitializeComponent();
            FormPrincipal.finestraOberta = true;
        }

        public FormGestio(String opcioMenu)
            : this()
        {
            //Si s'ha enviat manegar totes les taules:
            if (opcioMenu.Equals("tots"))
            {
                this.guardarButton.Enabled = true;
                this.dataGridView.ReadOnly = false;
                this.taulesComboBox.Enabled = true;
                carregaTaules();

                //Desactivar el boto d'esportar a XML:
                this.exportarXMLbutton.Enabled = false;
            }
            //...pero si s'ha enviat manegar una opcio especifica (a traves del menu):
            else
            {
                //Activa el boto d'esportar a XML:
                this.exportarXMLbutton.Enabled = true;

                this.guardarButton.Enabled = false;
                this.taulesComboBox.Enabled = false;
                this.dataGridView.ReadOnly = true;
                Hashtable sentencies = new Hashtable();

                sentencies["agents"] = "SELECT nom, cognom1, cognom2, nif FROM usuaris AS a LEFT JOIN persones AS b ON a.id_persona = b.id_persona LEFT JOIN entitats AS c ON b.id_entitat = c.id_entitat WHERE a.tipus LIKE 'agent'";
                sentencies["inspectors"] = "SELECT nom, cognom1, cognom2, nif FROM usuaris AS a LEFT JOIN persones AS b ON a.id_persona = b.id_persona LEFT JOIN entitats AS c ON b.id_entitat = c.id_entitat WHERE a.tipus LIKE 'inspector'";
                sentencies["venedors"] = "SELECT nom, cognom1, cognom2, nif FROM usuaris AS a LEFT JOIN persones AS b ON a.id_persona = b.id_persona LEFT JOIN entitats AS c ON b.id_entitat = c.id_entitat WHERE a.tipus LIKE 'venedor'";
                
                sentencies["clientsEmpreses"] = "SELECT rao_social, nif FROM clients AS a LEFT JOIN entitats AS b ON a.id_entitat = b.id_entitat LEFT JOIN empreses AS c ON b.id_entitat = c.id_entitat WHERE b.tipus = 'empresa'";
                sentencies["clientsParticulars"] = "SELECT nom, cognom1, cognom2, nif FROM clients AS a LEFT JOIN entitats AS b ON a.id_entitat = b.id_entitat LEFT JOIN persones AS c ON b.id_entitat = c.id_entitat WHERE b.tipus = 'persona'";
                
                sentencies["comptes"] = "SELECT nom, clau FROM comptes WHERE nom NOT LIKE 'admin'";

                sentencies["immobles_alquilats"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM immobles AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'immoble' AND EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["immobles_lliures"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM immobles AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'immoble' AND NOT EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["immobles_tots"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM immobles AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'immoble'";

                sentencies["polivalents_alquilats"] = "SELECT superficie, caracteristiques, caracteristiques_polivalent, restriccions, preu, adresa FROM polivalents AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'polivalent' AND EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["polivalents_lliures"] = "SELECT superficie, caracteristiques, caracteristiques_polivalent, restriccions, preu, adresa FROM polivalents AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'polivalent' AND NOT EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["polivalents_tots"] = "SELECT superficie, caracteristiques, caracteristiques_polivalent, restriccions, preu, adresa FROM polivalents AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'polivalent'";

                sentencies["oficines_alquilats"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM oficines AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'oficina' AND EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["oficines_lliures"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM oficines AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'oficina' AND NOT EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["oficines_tots"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM oficines AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'oficina'";

                sentencies["bm_alquilats"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM botigues_magatzem AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'botiga_magatzem' AND EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["bm_lliures"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM botigues_magatzem AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'botiga_magatzem' AND NOT EXISTS (SELECT * FROM contractes AS e WHERE b.id_local = e.id_local AND data_inici <= NOW() AND data_fi >= NOW())";
                sentencies["bm_tots"] = "SELECT superficie, caracteristiques, restriccions, preu, adresa FROM botigues_magatzem AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS d ON b.id_adresa = d.id_adresa WHERE b.tipus = 'botiga_magatzem'";

                sentencies["contractesVigents"] = "SELECT date_format(data_inici, '%c/%d/%Y') as data_inici, date_format(data_fi, '%c/%d/%Y') as data_fi, d.nif AS nif_propietari, codi_local, h.nif AS nif_llogater FROM contractes AS a LEFT JOIN propietaris AS b ON a.id_propietari = b.id_propietari LEFT JOIN clients AS c ON b.id_client = c.id_client LEFT JOIN entitats AS d ON c.id_entitat = d.id_entitat LEFT JOIN locals AS e ON a.id_local = e.id_local LEFT JOIN llogaters AS f ON a.id_llogater = f.id_llogater LEFT JOIN clients AS g ON f.id_client = g.id_client LEFT JOIN entitats AS h ON g.id_entitat = h.id_entitat WHERE data_inici <= NOW() AND data_fi >= NOW()";
                sentencies["contractesAcabats"] = "SELECT date_format(data_inici, '%c/%d/%Y') as data_inici, date_format(data_fi, '%c/%d/%Y') as data_fi, d.nif AS nif_propietari, codi_local, h.nif AS nif_llogater FROM contractes AS a LEFT JOIN propietaris AS b ON a.id_propietari = b.id_propietari LEFT JOIN clients AS c ON b.id_client = c.id_client LEFT JOIN entitats AS d ON c.id_entitat = d.id_entitat LEFT JOIN locals AS e ON a.id_local = e.id_local LEFT JOIN llogaters AS f ON a.id_llogater = f.id_llogater LEFT JOIN clients AS g ON f.id_client = g.id_client LEFT JOIN entitats AS h ON g.id_entitat = h.id_entitat WHERE data_inici > NOW() OR data_fi < NOW()";
                sentencies["contractesTots"] = "SELECT date_format(data_inici, '%c/%d/%Y') as data_inici, date_format(data_fi, '%c/%d/%Y') as data_fi, d.nif AS nif_propietari, codi_local, h.nif AS nif_llogater FROM contractes AS a LEFT JOIN propietaris AS b ON a.id_propietari = b.id_propietari LEFT JOIN clients AS c ON b.id_client = c.id_client LEFT JOIN entitats AS d ON c.id_entitat = d.id_entitat LEFT JOIN locals AS e ON a.id_local = e.id_local LEFT JOIN llogaters AS f ON a.id_llogater = f.id_llogater LEFT JOIN clients AS g ON f.id_client = g.id_client LEFT JOIN entitats AS h ON g.id_entitat = h.id_entitat";
                
                carregaDataGrid((String) sentencies[opcioMenu]);
            }
        }

        //Omple el combobox taulesComboBox amb totes les taules de la nostra base de dades:
        private void carregaTaules()
        {
            String sentenciaTaules = "SHOW tables"; //FROM "+ FormPrincipal.baseDatos.getBaseDatos();
            String taula = "";
            MySqlDataReader dataReader = FormPrincipal.baseDatos.consulta(sentenciaTaules);

            while (dataReader != null && dataReader.Read())
            {
                taula = dataReader.GetString(0);
                this.taulesComboBox.Items.Add(taula);
            }
        }

        //Metode que s'executa al seleccionar un element del combobox taulesComboBox:
        private void taulesComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //Omple el dataGridView amb les dades de la taula seleccionada:
            String taulaSeleccionada = (String) this.taulesComboBox.Items[this.taulesComboBox.SelectedIndex];
            String instruccio = "SELECT * FROM "+taulaSeleccionada;

            //Canvia la instruccio a una especifica si la taula te dates (si no, dona error de conversio del format DATA de mySQL a System.DateTime):
            if (taulaSeleccionada == "cerques")
            {
                instruccio = "SELECT id_cerca, superficie_minima, preu, caracteristiques, tipus, date_format(data_inici, '%c/%d/%Y') as data_inici, date_format(data_fi, '%c/%d/%Y') as data_fi FROM cerques";
            }
            else if (taulaSeleccionada == "contractes")
            {
                instruccio = "SELECT id_contracte, id_propietari, id_local, id_llogater, actiu, date_format(data_inici, '%c/%d/%Y') as data_inici, date_format(data_fi, '%c/%d/%Y') as data_fi FROM contractes";
            }

            if (taulaSeleccionada.Equals("comptes"))
                instruccio += " WHERE nom != 'admin'";
            carregaDataGrid(instruccio);

            //Activa el boto d'esportar a XML:
            this.exportarXMLbutton.Enabled = true;
        }

        //Carrega el datagrid a partir d'una instruccio SQL:
        private void carregaDataGrid(String sql)
        {
            DataSet dataSet = null;
            dataSet = FormPrincipal.baseDatos.consultaDataSet(sql);

            if (dataSet != null)
            {
                this.dataGridView.DataSource = dataSet.Tables[0];
            }
        }

        //Metode que s'executa al fer click al boto guardar:
        private void guardarButton_Click(object sender, EventArgs e)
        {
            //Guarda els canvis:
            new MySqlCommandBuilder(FormPrincipal.baseDatos.dataAdapter);
            FormPrincipal.baseDatos.dataAdapter.Update(FormPrincipal.baseDatos.dataSet, "miDataSet");
            this.dataGridView.Update();
        }
        
        private void taulesComboBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
        }

        //Metode que s'executa al tancar el formulari:
        private void FormGestio_FormClosed(object sender, FormClosedEventArgs e)
        {
            FormPrincipal.finestraOberta = false;
            ((FormPrincipal)this.MdiParent).menuStrip1.Enabled = true; //Torna a activar el menu del MDI.
        }
        
        //Funcio que s'executa al premer una tecla:
        private void FormGestio_KeyDown(object sender, KeyEventArgs e)
        {
            //Si la tecla es ESC, tanca el formulari:
            if (e.KeyCode == Keys.Escape)
            {
                this.Close();
            }
        }

        //Funcio que s'executa al fer click en el boto "Esportar a XML":
        private void exportarXMLbutton_Click(object sender, EventArgs e)
        {
            String dadesXML = FormPrincipal.baseDatos.getDataSet().GetXml();
            //MessageBox.Show(dadesXML);

            FormXML gestioChildForm = new FormXML(dadesXML);
            //gestioChildForm.MdiParent = this;
            gestioChildForm.Show();
        }
    }
}