<?php
	class Immobiliaria
	{
		private $locals; //Array de Local.
		private $entitats; //Array d'Entitat.
		private $adreses; //Array d'Adresa.
		private $zones; //Array de Zona.
		private $contractes; //Array de Contracte.
		private $telefons; //Array de Telefon.
		
		function __construct()
		{
			$this->carregaDades();
		}
		
		protected function setLocals($locals)
		{
			$this->locals = $locals;
		}
		
		public function getLocals()
		{
			return $this->locals;
		}

		protected function setEntitats($entitats)
		{
			$this->entitats = $entitats;
		}
		
		public function getEntitats()
		{
			return $this->entitats;
		}

		protected function setAdreses($adreses)
		{
			$this->adreses = $adreses;
		}
		
		public function getAdreses()
		{
			return $this->adreses;
		}

		protected function setZones($zones)
		{
			$this->zones = $zones;
		}
		
		public function getZones()
		{
			return $this->zones;
		}

		protected function setContractes($contractes)
		{
			$this->contractes = $contractes;
		}
		
		public function getContractes()
		{
			return $this->contractes;
		}

		protected function setTelefons($telefons)
		{
			$this->contractes = $contractes;
		}
		
		public function getTelefons()
		{
			return $this->telefons;
		}

		public function carregaDades()
		{
			$this->carregaLocals();
			$this->carregaEntitats();
			$this->carregaAdreses();
			$this->carregaZones();
			$this->carregaContractes();
			$this->carregaTelefons();
		}
		
		public function carregaLocals()
		{
			global $bd;
			
			$instruccio = "SELECT id_local FROM locals";
			$resultats = $bd->consulta($instruccio);
			
			$locals = Array();
			while ($row = mysql_fetch_assoc($resultats))
			{
				$id_local = $row["id_local"];

				$local = new Local($id_local);
				$locals[] = $local;
			}
			
			$this->setLocals($locals);
		}

		public function  carregaEntitats()
		{
			//No fa falta implementar.
		}

		public function  carregaAdreses()
		{
			//No fa falta implementar.
		}

		public function  carregaZones()
		{
			global $bd;
			
			$instruccio = "SELECT id_zona FROM zones";
			$resultats = $bd->consulta($instruccio);
			
			$zones = Array();
			while ($row = mysql_fetch_assoc($resultats))
			{
				$id_zona = $row["id_zona"];

				$zona = new Zona($id_zona);
				
				$zones[] = $zona;
			}
			
			$this->setZones($zones);
		}

		public function  carregaContractes()
		{
			//No fa falta implementar.
		}

		public function  carregaTelefons()
		{
			//No fa falta implementar.
		}
		
	}


	class Data
	{
		protected $any; //Any de la data (int).
		protected $mes; //Mes de la data (int).
		protected $dia; //Dia de la data (int).
		protected $milisegons = 0; //Milisegons que representa la data (long).
		
		public function Data($diaOmilisegons, $mes = "", $any = "")
		{
			if (trim($mes) == "" || trim($any) == "")
			{
				$this->setMilisegons($diaOmilisegons);
			}
			else
			{
				$this->setAny($any);
				$this->setMes($mes);
				$this->setDia($diaOmilisegons);
			}
		}
		
		public function getAny()
		{
			return $this->any;
		}
		
		public function setAny($any)
		{
			//FALTA: comprovar que fiquin un any coherent.
			$this->any = $any;
			$this->setMilisegons(mktime(0, 0, 0, $this->getMes(), $this->getDia(), $this->getAny()));
		}
		
		public function getMes()
		{
			return $this->mes;
		}
		
		public function setMes($mes)
		{
			if ($mes >= 1 && $mes <= 12)
			{
				$this->mes = $mes;
				$this->setMilisegons(mktime(0, 0, 0, $this->getMes(), $this->getDia(), $this->getAny()));
			}
		}

		public function getDia()
		{
			return $this->dia;
		}
		
		public function setDia($dia)
		{
			//FALTA: comprovar que fiquin un dia valid (tenint en compta l'any i el mes que ja te ficats).
			$this->dia = $dia;
			$this->setMilisegons(mktime(0, 0, 0, $this->getMes(), $this->getDia(), $this->getAny()));
		}

		public function getMilisegons()
		{
			return $this->milisegons;
		}
		
		public function setMilisegons($milisegons)
		{
			$this->milisegons = $milisegons;
		}

		public function getYYYYMMDD()
		{
			return $this->getAny() . "-" . $this->getMes() . "-" . $this->getDia();
		}

		//Retorna si la data d'aquest objecte es posterior a una data enviada per parametre:
		public function esIgual($altraData)
		{
			$esIgual = ($altraData->getDia() == $this->getDia && $altraData->getMes() == $this->getMes && $altraData->getAny() == $this->getAny);
			return $esIgual;
		}
		
		//Retorna si la data d'aquest objecte es posterior a una data enviada per parametre:
		public function esPosterior($altraData)
		{
			$esPosterior = false;
			
			if (!$this->esIgual($altraData))
			{
				//FALTA.
			}
			
			return $esPosterior;
		}
		
		//Retorna si la data d'aquest objecte es anterior a una data enviada per parametre:
		public function esAnterior($altraData)
		{
			$esAnterior = false;
			
			if (!$this->esIgual($altraData))
			{
				$esAnterior = !$esPosterior($altraData);
			}
			
			return $esAnterior;
		}

		//Retorna un objecte Data amb el mateix dia:
		public function copia()
		{
			return new Data($this->getDia(), $this->getMes(), $this->getAny());
		}
		
		//Retorna un objecte Data amb el dia seguent:
		public function diaSeguent()
		{
			//Falta.
		}

		//Retorna un objecte Data amb el dia anterior:
		public function diaAnterior()
		{
			//Falta.
		}
		
		//Retorna la data en un format que entengui la BD:
		public function getDataBD()
		{
			return $this->toString(); //Nota: pot ser s'ha de canviar.
		}
		
		//Retorna la temporada en la que es trova la data continguda en aquest objecte:
		public static function getTemporada()
		{
			//FALTA.
		}
		
		//Retorna un objecte Data amb la data actual:
		public static function dataActual()
		{
			//Falta.
		}

		//Retorna si un objecte Data es valid o no:
		public static function dataValida($data)
		{
			//Falta.
			return true;
		}
		
		//Comprova si dos periodes "colisionen":
		public static function periodesColisionen(Data $dataIniciA, Data $dataFiA, Data $dataIniciB, Data $dataFiB) //Nota: las dates han de tenir els milisegons ficats.
		{
			return ($dataIniciA->getMilisegons() <= $dataFiB->getMilisegons() && $dataFiA->getMilisegons() >= $dataIniciB->getMilisegons());
		}

		public static function toString()
		{
			return $this->getDia() . "/" . $this->getMes() . "/" . $this->getAny();
		}
	}
?>