<?php
	//Comprova si s'ha enviat el formulari de cerca:
	echo "<center>";
	$cercaEnviada = FALSE;
	if (formulariCercarEnviat($post) && formulariCercarValid($post)) //Si cal, mostrara errors.
	{
		$cercaEnviada = TRUE;
	}
	echo "</center>";

	//Mostra el formulari de cercar:
	$post = getPost();
	formulariIdentificacioCercar($post);
	
	//Si s'ha enviat la cerca, la processa:
	if ($cercaEnviada)
	{
		//Fa la cerca:
		ferCerca($post);
	}

	//Funcio que mostra el formulari de cercar:
	function formulariIdentificacioCercar($post)
	{
		global $immobiliaria;

		//Recupera les dades enviades:
		$zonesEnviades = Array();
		$tipusEnviat = "";
		$superficieMinimaEnviada = "";
		$dataIniciEnviada = "";
		$dataFiEnviada = "";
		$preuEnviat = "";
		$caracteristiquesEnviades = "";
		$guardaCercaEnviat = FALSE;
		if (isset($post["zones"])) { $zonesEnviades = $post["zones"]; }
		if (isset($post["tipus"])) { $tipusEnviat = trim($post["tipus"]); }
		if (isset($post["superficie_minima"])) { $superficieMinimaEnviada = trim($post["superficie_minima"]); }
		if (isset($post["data_inici"])) { $dataIniciEnviada = trim($post["data_inici"]); }
		if (isset($post["data_fi"])) { $dataFiEnviada = trim($post["data_fi"]); }
		if (isset($post["preu"])) { $preuEnviat = trim($post["preu"]); }
		if (isset($post["caracteristiques"])) { $caracteristiquesEnviades = trim($post["caracteristiques"]); }
		if (isset($post["guarda_cerca"])) { $guardaCercaEnviat = (trim($post["guarda_cerca"]) == "1") ? TRUE : FALSE; }
		?>
		<form action="<?php echo arxiuActual; ?>" method="post" class="cercar" onSubmit="return validarFormulariCercar();">
			<?php echo sessioForm; ?>
			<input type="hidden" name="cerca" value="enviada">
			<table align="center" class="cercar">
				<tr>
					<td class="cercar" align="right">
						Zones:
					</td>
					<td class="cercar">
						<select name="zones[]" id="zones" class="cerca_select_multiple" multiple>
							<?php
								$zones = $immobiliaria->getZones();
								
								foreach ($zones as $zona)
								{
									$id_zona = $zona->getIdZona();
									$descripcio_zona = htmlentities($zona->getDescripcio()); //$zona->getDescripcio();
									$selected = "";
									if (in_array($id_zona, $zonesEnviades)) { $selected = " selected"; }
									echo '<option value="'.$id_zona.'"' . $selected .'>' . $descripcio_zona . '</option>';
								}
							?>
						</select>
					</td>
				</tr>
				<tr>
					<td class="cercar" align="right">
						Tipus de local:
					</td>
					<td class="cercar">
						<select name="tipus" id="tipus" class="cerca_select">
							<?php
								$tipus = Array(
												"tots" => "Tots",
												"botiga_magatzem" => "Botigues-Magatzem",
												"oficina" => "Oficines",
												"polivalent" => "Polivalents",
												"immoble" => "Immobles"
												);
												
								foreach ($tipus as $k => $v)
								{
									$selected = "";
									if ($k == $tipusEnviat) { $selected = " selected"; }
									echo '<option value="'.$k.'"' . $selected .'>' . $v . '</option>';
								}
							?>
						</select>
					</td>
				</tr>
				<tr>
					<td class="cercar" align="right">
						* Superf&iacute;cia m&iacute;nima:
					</td>
					<td class="cercar">
						<input type="text" name="superficie_minima" id="superficie_minima" value="<?php echo $superficieMinimaEnviada; ?>" size="11" maxlength="10" class="cercar_text">
						m<sup>2</sup>
					</td>
				</tr>
				<tr>
					<td class="cercar" align="right">
						Data d'inici:
					</td>
					<td>
						<input type="text" name="data_inici" id="data_inici" value="<?php echo $dataIniciEnviada; ?>" size="10" maxlength="9" class="cercar_data" readonly>
						<a href="javascript:NewCal('data_inici','yyyymmdd')"><img src="js/datetimepick/cal.gif" width="16" height="16" border="0" alt="Escollir una data" title="Escollir una data"></a>
					</td>
				</tr>
				<tr>
					<td class="cercar" align="right">
						Data de fi:
					</td>
					<td>
						<input type="text" name="data_fi" id="data_fi" value="<?php echo $dataFiEnviada; ?>" size="10" maxlength="9" class="cercar_data" readonly>
						<a href="javascript:NewCal('data_fi','yyyymmdd')"><img src="js/datetimepick/cal.gif" width="16" height="16" border="0" alt="Escollir una data" title="Escollir una data"></a>
					</td>
				</tr>
				<tr>
					<td class="cercar" align="right">
						Preu m&aacute;xim:
					</td>
					<td class="cercar">
						<input type="text" name="preu" id="preu" value="<?php echo $preuEnviat; ?>" class="cercar_text" size="12" maxlength="11">
						euros
					</td>
				</tr>
				<tr>
					<td class="cercar" align="right">
						Caracter&iacute;stiques:
					</td>
					<td>
						<textarea name="caracteristiques" id="caracteristiques" class="cercar_textarea"><?php echo $caracteristiquesEnviades; ?></textarea>
					</td>
				</tr>
				<?php
				if (usuariIdentificat())
				{
				?>
					<tr>
						<td class="cercar" colspan="2" align="center">
							<label for="guarda_cerca" class="cerca_checkbox"><input type="checkbox" name="guarda_cerca" id="guarda_cerca" value="1" class="cerca_checkbox"<?php if ($guardaCercaEnviat) { echo " checked"; } ?>>Guarda cerca</label>
						</td>
					</tr>
				<?php
				}
				?>
				<tr>
					<td class="cercar" colspan="2" align="center">
						* Els marcats amb asterisc s&oacute;n obligatoris.
						<br />
						<input type="submit" name="boto" value="Cerca" class="cercar_boto">
					</td>
				</tr>
			</table>
		</form>
		<?php
	}
	
	//Funcio que retorna si s'ha enviat o no el formulari d'identificacio:
	function formulariCercarEnviat($post)
	{
		return (isset($post["cerca"]) && trim($post["cerca"]) == "enviada");
	}
	
	//Funcio que retorna si el formulari d'identificacio es valid o no:
	function formulariCercarValid($post)
	{
		$errors = "";
		
		//Recupera les dades enviades:
		$zonesEnviades = Array();
		$tipusEnviat = "";
		$superficieMinimaEnviada = "";
		$preuEnviat = "";
		if (isset($post["zones"])) { $zonesEnviades = $post["zones"]; }
		if (isset($post["tipus"])) { $tipusEnviat = trim($post["tipus"]); }
		if (isset($post["superficie_minima"])) { $superficieMinimaEnviada = trim($post["superficie_minima"]); }
		if (isset($post["preu"])) { $preuEnviat = trim($post["preu"]); }

		//Comprova les dades:
		if (sizeof($zonesEnviades) <= 0)
		{
			$errors .= "<br />S'ha de ficar, al menys, una zona";
		}
		if ($post["tipus"] == "") //Aixo, en teoria, no passaria mai.
		{
			$errors .= "<br />S'ha de ficar un tipus";
		}
		if ($superficieMinimaEnviada == "" || !is_numeric($superficieMinimaEnviada) || $superficieMinimaEnviada < 0)
		{
			$errors .= "<br />S'ha de ficar una superf&iacute;cie m&iacute;nima i ha de ser num&eacute;ric superior o igual a 0";
		}
		if ($preuEnviat != "" && (!is_numeric($preuEnviat) || $preuEnviat < 0))
		{
			$errors .= "<br />El preu ha de ser num&eacute;ric superior o igual a 0";
		}
		
		//Si han hagut errors, mostra el missatge pertinent:
		if ($errors != "")
		{
			mostraError("Formulari incorrecte:", $errors . "<br /><br />");
		}
	
		//Retorna true o false segons les dades son valides o no:
		return ($errors == "");
	}

	//Funcio que realitza la cerca:
	function ferCerca($post)
	{
		//Recupera les dades enviades:
		$zonesEnviades = Array();
		$tipusEnviat = "";
		$superficieMinimaEnviada = "";
		$dataIniciEnviada = "";
		$dataFiEnviada = "";
		$preuEnviat = "";
		$guardaCercaEnviat = FALSE;
		$caracteristiquesEnviades = "";
		if (isset($post["zones"])) { $zonesEnviades = $post["zones"]; }
		if (isset($post["tipus"])) { $tipusEnviat = trim($post["tipus"]); }
		if (isset($post["superficie_minima"])) { $superficieMinimaEnviada = trim($post["superficie_minima"]); }
		if (isset($post["data_inici"])) { $dataIniciEnviada = trim($post["data_inici"]); }
		if (isset($post["data_fi"])) { $dataFiEnviada = trim($post["data_fi"]); }
		if (isset($post["preu"])) { $preuEnviat = trim($post["preu"]); }
		if (isset($post["caracteristiques"])) { $caracteristiquesEnviades = trim($post["caracteristiques"]); }
		if (isset($post["guarda_cerca"])) { $guardaCercaEnviat = (trim($post["guarda_cerca"]) == "1") ? TRUE : FALSE; }
				
		$termes = explode("-", $dataIniciEnviada);
		$dataIniciEnviada = new Data(0);
		if (sizeof($termes) >= 3)
		{
			$dia = $termes[2];
			$mes = $termes[1];
			$any = $termes[0];
			$dataIniciEnviada = new Data($dia, $mes, $any);
		}
		$termes = explode("-", $dataFiEnviada);
		$dataFiEnviada = new Data(0);
		if (sizeof($termes) >= 3)
		{
			$dia = $termes[2];
			$mes = $termes[1];
			$any = $termes[0];
			$dataFiEnviada = new Data($dia, $mes, $any);
		}
		
		$zonesEnviadesObjectes = Array();
		foreach ($zonesEnviades as $id_zona)
		{
			$zonesEnviadesObjectes[] = new Zona($id_zona);
		}
		
		//Crea i mostra la cerca:
		echo "<h2>Resultats:</h2>";
		$cerca = new Cerca();
		$cerca->seleccionaLocals($zonesEnviadesObjectes, $tipusEnviat, $superficieMinimaEnviada, $dataIniciEnviada, $dataFiEnviada, $preuEnviat, $caracteristiquesEnviades);
		if (sizeof($cerca->getLocals()) > 0)
		{
			$cerca->mostra();
		} else { mostraMissatge("", "Sense resultats"); }
		
		//Si es usuari registrat i s'ha definit aixi, guarda la cerca:
		if (usuariIdentificat() && $guardaCercaEnviat)
		{
			$session = getSession();
			$entitat = $session["entitat_identificada"];
			$compte = $entitat->getCompte();
			$cerca->guarda($compte);

			//Torna a ficar el objecte ja modificat en la sessio.
			$entitat = new Entitat($entitat->getIdentitat());
			setSession("entitat_identificada", $entitat);
		}
	}
?>