<?php
	//Funcion que hace una votacion siempre que sea posible y no deja hacer mas despues:
	function procesar_encuesta($respuestas)
	{
		//Si no se permite el voto, sale:
		if (!recoger_sesion("permitir_voto")) { return FALSE; } //Retorna que aun no se ha votado.
		
		//Si se ha enviado una votacion, comprueba que sea valida y la procesa si es asi:
		$votacion_realizada = recoger_sesion("votacion_realizada");
		$respuesta = recoger_get("respuesta");
		
		if (array_key_exists($respuesta, $respuestas))
		{
			if (!$votacion_realizada)
			{
				setear_sesion("votacion_realizada", TRUE);
		
				$puntero = fopen("contenido/encuesta/" . $respuesta . ".txt", "a+b");
				$votos = (int) fgets($puntero);
				fclose($puntero);

				$puntero = fopen("contenido/encuesta/" . $respuesta . ".txt", "wb");
				fputs($puntero, $votos + 1);
				fclose($puntero);
			}
		}

		$votacion_realizada = recoger_sesion("votacion_realizada");
		
		return $votacion_realizada;
	}
	

	//Funcion que muestra un sistema de encuesta (preguntas y sus respuestas despues del voto, etc):
	function encuesta($pregunta, $respuestas, $color_barras, $traduccion_encuesta)
	{
		global $votacion_realizada, $this_file, $idioma;
		
		//Contenido	del sistema de votacion (hace falta traducir algunas cosas):
		echo '<center><font size="4" color="#6666aa" face="verdana">' . $traduccion_encuesta["pregunta"] . ':</font> <font size="6" color="#0000aa" face="verdana"><i>' . $pregunta . '</i></font><br><br>';
		if (!$votacion_realizada)
		{
			echo '<center><font size="4" color="#6666aa" face="verdana">' . $traduccion_encuesta["escoge"] . ':</font><br>';
			foreach ($respuestas as $k => $respuesta)
			{
				echo '<font size="3" color="#0000aa" face="verdana"><i><a href="' . $this_file . '?idioma=' . $idioma . '&respuesta=' . $k . '" title="' . $respuesta . '" class="enlace2">' . $respuesta . '</a></i></font><br>';
			}
		}
		else { echo '<font size="3" color="#0000aa" face="verdana">' . $traduccion_encuesta["gracias"] . '</font><br>'; }
		echo '<br><font size="4" color="#6666aa" face="verdana">' . $traduccion_encuesta["resultados"] . ':</font><br>';
		echo '<table cellspacing="2" cellpadding="6" align="center" width="90%">';
		$votos = Array();
		$votos_total = 0;
		foreach ($respuestas as $k => $respuesta)
		{
			$archivo = "contenido/encuesta/" . $k . ".txt";
			if (file_exists($archivo))
			{
				$votos[$k] = (int) (trim(implode(file($archivo))));
				$votos_total += $votos[$k];
			} else { $votos[$k] = 0; }
		}
		$fondo_par_impar = "#0000aa";
		$color_par_impar = "#ffffff";
		foreach ($respuestas as $k => $respuesta)
		{
			$porcentaje = $votos[$k] / $votos_total * 100;
			echo '<tr>';
			echo '<td bgcolor="' . $fondo_par_impar . '" align="center" width="30%" title="' . $respuesta . '">';
			echo '<font size="2" color="' . $color_par_impar . '" face="arial">';
			echo "<center><b>$respuesta</b></center>";
			echo '</font>';
			echo '</td>';
			echo '<td bgcolor="' . $fondo_par_impar . '">';
			echo '<font size="1" color="' . $color_par_impar . '" face="arial">';
			echo "($votos[$k])<br>";
			$pixels = (int) $porcentaje;
			if ($pixels == 0) { $pixels = 1; }
			echo '<table border="0" cellspacing="0" cellpadding="0" title="' . $votos[$k] . ' (' . number_format($porcentaje, 2, ",", ".") . '%)" bgcolor="' . $color_barras[$k] . '" width="' . $pixels . '%" height="20"><tr><td></td></tr></table>';
			echo '</font>';
			echo '</td>';
			echo '<td bgcolor="' . $fondo_par_impar . '" align="center" width="10%"><center>';
			echo '<font size="1" color="' . $color_par_impar . '" face="arial">';
			echo number_format($porcentaje, 2, ",", ".") . "%<br>";
			echo '</font>';
			echo '</center></td>';
			echo '</tr>';
			$fondo_par_impar = ($fondo_par_impar == "#0000aa") ? "#ffffff" : "#0000aa";
			$color_par_impar = ($fondo_par_impar == "#0000aa") ? "#ffffff" : "#0000aa";
		}
		echo '</table></center>';
	}
	
	//Funcion que define si se permite votar o no:
	function permitir_votacion($permitir)
	{
		setear_sesion("permitir_voto", $permitir);
	}
?>
