<?php


    //Archivo "ejer3_inc.php", que se incluye al principio de "ejer3.php" ->


    //Las peliculas se dividen en tres matrices; $titulos, $directores, $estrenos:

    // Titulos de las peliculas:
    $titulos = array(
                        0 => "El gran dictador",
                        1 => "En busca del arca perdida",
                        2 => "Los pjaros",
                        3 => "Pulp Fiction",
                        4 => "The Matrix",
                        5 => "2001:una odisea en el espacio",
                        6 => "Lawrence de Arabia"
                    );    

    // Directores de las peliculas:
    $directores = array(
                        0 => "Charles Chaplin",
                        1 => "Steven Spilberg",
                        2 => "Alfred Hitchcock",
                        3 => "Quentin Tarantino",
                        4 => "Andy y Larry Wachowski",
                        5 => "Stanley Kubrick",
                        6 => "David Lean"
                       );

    // Estrenos de las peliculas:
    $estrenos = array(
                        0 => 1940,
                        1 => 1981,
                        2 => 1963,
                        3 => 1994,
                        4 => 1999,
                        5 => 1968,
                        6 => 1962
                     );


    //Definimos una clase de objeto que realizara las operaciones con las peliculas:
    class operaciones_listado
     {

        var $coleccion;

        //Metodo constructor (se ejecuta al crear el objecto, ya que tiene el mismo nombre que la clase) para crear la propiedad "coleccion" del objeto:
        function operaciones_listado()
         {

            //Cambiamos el ambito a global de las siguientes variables, para poder utilizarlas dentro de la funcion:
            global $titulos;
            global $directores;
            global $estrenos;
            
            //Creamos una array con la coleccion, gracias a los datos que teniamos antes:
            $this->coleccion = array(
                                     "titulos" => $titulos,
                                     "directores" => $directores,
                                     "estrenos" => $estrenos
                                    );

         } //Fin del modulo constructor "operaciones_listado" (funcion).
         
        
        //Metodo para listar las peliculas (por defecto se listaran sin orden, a no ser que se envie $ordenar = TRUE):
        function listado($ordenar = FALSE)
         {

            //Se ordena la matriz (por valores y ascendente) antes de representarla, si $ordenar = TRUE:
            if ($ordenar) { asort($this->coleccion["titulos"]); }

            //Se muestra la tabla con las peliculas:
            echo "<table border=\"2\">";
            echo "<tr>";
            echo "<td><font color=\"#0000ff\"><b>Nombre</b></font></td>";
            echo "<td><font color=\"#0000ff\"><b>Director</b></font></td>";
            echo "<td><font color=\"#0000ff\"><b>A&ntilde;o</b></font></td>";
            echo "</tr>";

            //Realizamos un bucle en la propiedad "coleccion" del objeto, con tantos "loops" como valores tenga el indice "titulos" de esta propiedad:
            foreach ($this->coleccion["titulos"] as $indice => $valor)
             {
                echo "<tr>";
                //Muestra el titulo:
                echo "<td><b>".$this->coleccion["titulos"][$indice]."</b></td>";
                //Muestra el director:
                echo "<td><b>".$this->coleccion["directores"][$indice]."</b></td>";
                //Muestra el estreno:
                echo "<td><b>".$this->coleccion["estrenos"][$indice]."</b></td>";
                echo "</tr>";
             } //Fin foreach

            //Finaliza la tabla con las peliculas:
            echo "</table>";

         } //Fin del modulo "listado" (funcion).
         
         
        //Metodo para buscar peliculas y mostrarlas (no busca por estreno, solo por titulo y director, ya que el ejemplo no lo hacia):
        function buscar($texto)
         {

            //Borramos los espacios al principio y al final del texto enviado en la busqueda:
            $texto = trim($texto);

            echo "Las pel&iacute;culas que contienen '<b>".$texto."</b>' en el t&iacute;tulo o en el director son:<br>";

            //Mostramos la tabla:
            echo "<table border=\"2\"><br>";
            echo "<tr>";
            echo "<td><font color=\"#0000ff\"><b>Nombre</b></font></td>";
            echo "<td><font color=\"#0000ff\"><b>Director</b></font></td>";
            echo "<td><font color=\"#0000ff\"><b>A&ntilde;o</b></font></td>";
            echo "</tr>";

            //Realizamos un bucle con tantos "loops" como valores tiene el indice "titulos" de la propiedad "coleccion" del objeto:
            foreach ($this->coleccion["titulos"] as $indice => $valor)
             {
                //Calculamos si la siguiente operacion con "stristr" devuelve TRUE al buscar en los indices "titulos" y "directores" (de la propiedad "coleccion" del objeto) el texto enviado:
                if (stristr($this->coleccion["titulos"][$indice], $texto) || stristr($this->coleccion["directores"][$indice], $texto))
                 {
                    echo "<tr>";
                    //Muestra el titulo:
                    echo "<td><b>".$this->coleccion["titulos"][$indice]."</b></td>";
                    //Muestra el director:
                    echo "<td><b>".$this->coleccion["directores"][$indice]."</b></td>";
                    //Muestra el estreno:
                    echo "<td><b>".$this->coleccion["estrenos"][$indice]."</b></td>";
                    echo "</tr>";
                 } //Fin if.
            } //Fin foreach.
            
            //Finalizamos la tabla:
            echo "</table>";
            
         } //Fin del modulo "buscar" (funcion).
            
     } //Fin de la clase.


?>
