﻿//PROXIMA DIA: Hacer la animacion de intercambio de intercambiar. 

//Incluye las clases necesarias:
import as.Registro;

//Clase para el ranking:
class as.Ranking
{
	static var numeroRegistros : Number = 20; //Numero maximo de registros para el ranking.
	static var archivoRanking : String = "datos/ranking.txt"; //Archivo de donde leer los registros.

	var milisegundosCiclo : Number = 2000; //Milisegundos que tarda en volver a leer el ranking, al iniciar el ciclo.
	var intervalCiclo : Number = null; //Variable que guarda el interval para hacer el ciclo (si, es numerica).

	static var espacioEntreRegistros : Number = 40; //Numero de pixels entre un registro y otro.
	static var rankingLeft : Number = 10; //Posicion horizontal, en pixels, del ranking.
	static var anchoRegistro : Number = 500; //Ancho en pixels de cada registro.
	static var altoRegistro : Number = 40; //Alto en pixels de cada registro.
	static var margenRegistro : Number = 10; //Alto en pixels de cada registro.
	
	static var movieClip : MovieClip = null; //Guarda el MovieClip donde se representa el ranking.

	static var registros : Array = new Array(); //Guarda los registros del ranking.
	//static var registrosAnteriores : Array = new Array(); //Guarda los antiguos registros del ranking, de la anterior pasada.
	
	static var registrosClips : Array = new Array(); //Guarda los clips de pelicula de cada posicion del ranking.

	static var alphaAparecer : Array = new Array(); //Alpha que utiliza la animacion de aparecer, para cada posicion del ranking.
	static var intervalAparecer : Array = new Array(); //Intervals de la animacion de aparecer, para cada posicion del ranking.

	static var altoDeslizar : Array = new Array(); //Alpha que utiliza la animacion de aparecer, para cada posicion del ranking.
	static var anchoDeslizar : Array = new Array(); //Alpha que utiliza la animacion de aparecer, para cada posicion del ranking.
	static var intervalDeslizar : Array = new Array(); //Intervals de la animacion de aparecer, para cada posicion del ranking.
	
	
	function Ranking(movieClip : MovieClip)
	{
		//Define el MovieClip necesario para representar el ranking:
		Ranking.setMovieClip(movieClip);
		//Carga los valores del ranking por primera vez:
		this.cargarRegistros();
		//Representa visualmente el ranking:
		//Ranking.representarRanking();
	}

	/*
	function Ranking()
	{
		this(numeroRegistros);
	}
	
	function Ranking(numeroRegistros : Number)
	{
		this(new Registro[numeroRegistros]);
	}
	
	function Ranking(registros : Array)
	{
		this.setNumeroRegistros(registros.length);
		this.setRegistros(registros);
	}
	*/
	
	static function setMovieClip(movieClip : MovieClip)
	{
		Ranking.movieClip = movieClip;
	}
	
	static function getMovieClip()
	{
		return Ranking.movieClip;
	}
	
	static function setNumeroRegistros(numeroRegistros : Number) : Void
	{
		Ranking.numeroRegistros = numeroRegistros;
	}
	
	static function getNumeroRegistros() : Number
	{
		return Ranking.numeroRegistros;
	}
	
	static function setRegistros(registros : Array) : Void
	{
		Ranking.registros = registros;
	}
	
	static function getRegistros() : Array
	{
		var registros : Array = new Array();
		for (var x = 0; x < Ranking.registros.length; x++)
		{
			registros[x] = Ranking.registros[x];
		}
		
		return registros;
	}
	
	static function setRegistro(registro : Registro, posicion : Number) : Void
	{
		Ranking.registros[posicion] = registro;
	}
	
	static function getRegistro(posicion : Number)
	{
		var registro : Registro = null;
		
		if (posicion < Ranking.registros.length)
		{
			registro = Ranking.registros[posicion];
		} else { trace("!!!!!!!!!!!!!!!! La posicion " + posicion + " supera la dimension! ("+Ranking.registros.length+")"); }
		
		return registro;
	}
	
	static function intercambiarRegistros(registro1 : Registro, posicion1 : Number, registro2 : Registro, posicion2 : Number) : Void
	{
		var temp : Registro = registro1;
		
		Ranking.setRegistro(registro2, posicion1);
		Ranking.setRegistro(temp, posicion2);
	}

	/*
	static function moverRegistro(registro1 : Registro, posicion1 : Number, posicion2 : Number) : Void
	{
		var temp : Registro = Ranking.getRegistro(posicion2);
		
		Ranking.setRegistro(registro, posicion2);
		Ranking.setRegistro(temp, posicion1);
	}
	*/
	
	static function setArchivoRanking(archivoRanking : String) : Void
	{
		Ranking.archivoRanking = archivoRanking;
	}
	
	static function getArchivoRanking() : String
	{
		return Ranking.archivoRanking;
	}
	
	function setMilisegundosCiclo(milisegundosCiclo : Number) : Void
	{
		this.milisegundosCiclo = milisegundosCiclo;
	}
	
	function getMilisegundosCiclo() : Number
	{
		return this.milisegundosCiclo;
	}
	
	static function setEspacioEntreRegistros(espacioEntreRegistros : Number) : Void
	{
		Ranking.espacioEntreRegistros = espacioEntreRegistros;
	}
	
	static function getEspacioEntreRegistros() : Number
	{
		return Ranking.espacioEntreRegistros;
	}
	
	static function setRankingLeft(rankingLeft : Number) : Void
	{
		Ranking.rankingLeft = rankingLeft;
	}
	
	static function getRankingLeft() : Number
	{
		return Ranking.rankingLeft;
	}
	
	static function setAnchoRegistro(anchoRegistro : Number) : Void
	{
		Ranking.anchoRegistro = anchoRegistro;
	}

	static function getAnchoRegistro() : Number
	{
		return Ranking.anchoRegistro;
	}
	
	static function setAltoRegistro(altoRegistro : Number) : Void
	{
		Ranking.altoRegistro = altoRegistro;
	}

	static function getAltoRegistro() : Number
	{
		return Ranking.altoRegistro;
	}
	
	static function setMargenRegistro(margenRegistro : Number) : Void
	{
		Ranking.margenRegistro = margenRegistro;
	}

	static function getMargenRegistro() : Number
	{
		return Ranking.margenRegistro;
	}
	
	//Almacena el clip de pelicula de un registro:
	static function setClipRegistro(movieClip : MovieClip, ID : Number) : Void
	{
		Ranking.registrosClips[ID] = movieClip;
	}
	
	//Devuelve el clip de pelicula de un registro:
	static function getClipRegistro(ID : Number) : MovieClip
	{
		var movieClip : MovieClip = null;
		
		//if (posicion < Ranking.registrosClips.length)
		{
			movieClip = Ranking.registrosClips[ID];
		}
		
		return movieClip;
	}
	
	//Inicia el ciclo de carga del ranking:
	function iniciarCiclo() : Void
	{
		//Si no esta comenzado, lo comienza:
		if (this.intervalCiclo == null)
		{
			this.intervalCiclo = setInterval(this.cargarRegistros, this.getMilisegundosCiclo());
		}
	}
	
	//Termia el ciclo de carga del ranking:
	function pararCiclo() : Void
	{
		clearInterval(this.intervalCiclo);
		this.intervalCiclo = null;
	}
	
	//Borra los espacios al principio y al finald e una cadena, y la retorna:
	static function trim(cadena : String) : String
	{
		//Quita los espacios de la izquierda:
		while (cadena.substring(0, 1) == " ")
		{
			cadena = cadena.substring(1, cadena.length);
		}
		
		//Quita los espacios de la derecha:
		while (cadena.substring(cadena.length - 1, cadena.length) == " ")
		{
			cadena = cadena.substring(0, cadena.length - 1)
		}

		return cadena;
	}
	
	//Reordena un vector de registros por su valor, de mayor a menor:
	static function ordenarPorValor(registros : Array) : Array
	{
		//Metodo de la burbuja:
		var temp : Registro;
		
		for (var x = registros.length - 1; x > 0; x--)
		{
			for (var y = 0; y < x; y++)
			{
				if (registros[y].getValor() < registros[y + 1].getValor())
				{
					temp = registros[y + 1];
					registros[y + 1] = registros[y];
					registros[y] = temp;
				}
			}
		}

		return registros;
	}
	
	//Devuelve la posicion de un registro dentro de un vector de regitros:
	static function calcularPosicion(registro : Registro, registros : Array) : Number
	{
		var posicion : Number = -1;
		
		var id : Number = registro.getID();
		
		for (var x = 0; x < registros.length; x++)
		{
			if (id == registros[x].getID())
			{
				posicion = x;
				break;
			}
		}
		
		return posicion;
	}
	
	//Carga los registros desde el archivo del ranking:
	function cargarRegistros() : Void
	{
		//Lee el archivo y lo carga en un vector (cogido de http://miprogramacionenjuegos.wordpress.com/2006/12/21/la-clase-loadvars-para-leer-datos-de-archivos-txt/):
		var archivoCargado = new LoadVars();
		
		//this.createTextField("Texto_123", 1, 50, 50, 200, 50); //???

		//Funcion a ejecutar cuando el archivo termine de cargarse:
		archivoCargado.onLoad = function(todoBien)
  					   		    {
									//Si se ha cargado correctamente el archivo:
									if (todoBien)
									{
										//Guarda los registros anteriores:
										var registrosAnteriores : Array = Ranking.getRegistros();

										//Guarda el texto del archivo en una variable:
										var texto : String = unescape(archivoCargado.toString());
										
										//Quita la cadena que por defecto pone el Flash (Macromedia Flash Professional 8):
										if (texto.indexOf("&onLoad=[type Function]", 0) != -1) { texto = texto.substring(0, texto.indexOf("&onLoad=[type Function]", 0)); }
										
										//Crea un vector con todos los registros:
										var filas : Array = texto.split(";");
										
										//trace("Texto del archivo:\n" + texto + "\n\n"); //Debug.
										
										//Guarda los registros nuevos:
										var registrosNuevos : Array = new Array();//Ranking.getNumeroRegistros());
										var columnas : Array = new Array();
										var columnaNombreValor : Array = new Array();
										var columnasValor : Array = new Array();
										var id : Number;
										var nombre : String;
										var valor : Number;
										var registro : Registro;
										for (var x = 0; x < filas.length; x++) //Desglosa cada registro en los valores de sus columnas.
										{
											//Desglosa la fila actual en sus columnas:
											columnas = filas[x].split(":");
											
											//Si no hay las columnas suficientes, salta este loop:
											if (columnas.length < 3) { continue; }
											
											//Recorre las columnas y recoge su valor, quitandoles espacios innecesarios:
											for (var y = 0; y < columnas.length; y++)
											{
												columnaNombreValor = columnas[y].split("=");
												if (columnaNombreValor.length >= 2)
												{
													columnasValor[y] = Ranking.trim(columnaNombreValor[1]);
												}
											}

											id = parseFloat(columnasValor[0]);
											nombre = columnasValor[1];
											valor = parseFloat(columnasValor[2]);
											
											//Guarda el nuevo registro:
											registro = new Registro(id, nombre, valor);
											registrosNuevos[x] = registro;
											//trace("Poniendo " + registrosNuevos[x]); //Debug.
										}
										
										//Ordena los registros antiguos y nuevos por su valor, de mayor a menor:
										registrosAnteriores = Ranking.ordenarPorValor(registrosAnteriores);
										registrosNuevos = Ranking.ordenarPorValor(registrosNuevos);
										
										//trace("Numero de valores nuevos: " + registrosNuevos.length + "."); //Debug.
										//trace("Numero de valores antiguos: " + registrosAnteriores.length + "."); //Debug.
										
										//Pone el numero de registros nuevo (por si cambiara):
										var registrosPuestos : Number = x - 1;
										Ranking.setNumeroRegistros(registrosPuestos);
										
										//Recorre los nuevos registros y si han cambiado, los mueve:
										var posicionAnterior : Number;
										var temp : Registro;
										for (x = 0; x < registrosPuestos; x++)
										//for (x = 0; x < Ranking.getNumeroRegistros(); x++)
										{
											if (x < registrosAnteriores.length)
											{
												//Si el registro ha cambiado de posicion en el ranking:
												if (registrosNuevos[x].getID() != registrosAnteriores[x].getID())
												{
													//Si encuentra el registro anterior, los mueve intercambiandolos:
													posicionAnterior = Ranking.calcularPosicion(registrosNuevos[x], registrosAnteriores); //Calcula donde estaba antes el registro nuevo.
													if (posicionAnterior >= 0)
													{
														trace("!!! El registro de la posicion " + posicionAnterior + " se mueve a la posicion " + x + " ("+registrosNuevos[x]+")"); //Debug.
														//Ranking.moverRegistro(registrosNuevos[posicionAnterior], posicionAnterior, registrosNuevos[x], x);
														Ranking.moverRegistro(registrosNuevos[x], posicionAnterior, x);
														
														//Modifica los registros anteriores, para que no los vuelva a intercambiar:
														//temp = registrosAnteriores[x];
														//registrosAnteriores[x] = registrosNuevos[x];
														//registrosAnteriores[posicionAnterior] = registrosNuevos[posicionAnterior];
														
														//Ranking.moverRegistro(registrosAnteriores[x], posicionAnterior, registrosNuevos[x], x);
													}
													//Si no, como el registro es nuevo lo hace aparecer:
													else
													{
														//trace("No se ha encontrado la posicion del registro anterior con id " + registrosAnteriores[x].getID() + ", en su lugar pone el registro con id " + registrosNuevos[x].getID()); //Debug.
														Ranking.aparecerRegistro(registrosNuevos[x], x);
													}
												}
												//else { trace("El registro de la posicion " + x + " esta en la misma posicion que antes y se queda igual."); } //Debug.
												//trace("Registro #" + x + ": "+registrosNuevos[x]); //Debug.
											}
											//...si no, antes no habia ningun registro en la posicion y lo hace aparecer:
											else
											{
												//trace("El registro de la posicion " + x + " es nuevo. Lo hace aparecer."); //Debug.
												Ranking.aparecerRegistro(registrosNuevos[x], x);
											}
										}
										
										//Define el nuevo ranking:
										//Ranking.setRegistros(registrosNuevos);
									}
							    };
								
		archivoCargado.load(Ranking.getArchivoRanking());
	}
	
	//Hace aparecer un registro en una posicion indicada:
	static function aparecerRegistro(registro : Registro, posicion : Number) : Void
	{
		//Almacena el registro que habia anteriormente:
		var registroAnterior : Registro = Ranking.getRegistro(posicion);
		
		//Inserta el registro en el ranking, de forma interna:
		Ranking.setRegistro(registro, posicion);

		Ranking.representarAnimacionAparecer(registro, posicion, registroAnterior);
	}
	
	//Mueve un registro del ranking a una posicion indicada:
	//static function moverRegistro(registroAnterior : Registro, posicionAnterior : Number, registro: Registro, posicionPosterior : Number) : Void
	static function moverRegistro(registro : Registro, posicionAnterior : Number, posicionPosterior : Number) : Void
	{
		//Si las posiciones estan consecutivas, ejecuta una animacion de "deslizamiento":
		if (Math.abs(posicionAnterior - posicionPosterior) == 1)
		{
			Ranking.representarAnimacionDeslizar(registro, posicionAnterior, posicionPosterior);
		}
		//...pero si no, ejecuta una animacion de "salto":
		else
		{
			Ranking.representarAnimacionIntercambiar(registro, posicionAnterior, posicionPosterior);
		}
		
		//Intercambia los registros en el ranking, de forma interna:
		//Ranking.intercambiarRegistros(registroAnterior, posicionAnterior, registro, posicionPosterior);
		Ranking.setRegistro(registro, posicionPosterior);
	}

	//Reproduce la animacion de aparecer un registro nuevo en una posicion:
	static function representarAnimacionAparecer(registro : Registro, posicion : Number, registroAnterior : Registro) : Void
	{
		trace("* Animacion de apareciendo registro en la posicion " + posicion);
		
		var movieClip : MovieClip = Ranking.getMovieClip();
		if (movieClip == null) { return; }
		
		var margenRegistro : Number = Ranking.getMargenRegistro();
		
		//Si habia un registro anterior, lo hace desaparecer:
		if (registroAnterior != null)
		{
			trace("Se borra el clip del registro anterior con id " + registroAnterior.getID());
			var clipRegistroAnterior : MovieClip = Ranking.getClipRegistro(registroAnterior.getID());
			clipRegistroAnterior.removeMovieClip();
			Ranking.setClipRegistro(null, registro.getID());
			//clipRegistroAnterior._alpha = 0;
			//clipRegistroAnterior.texto._alpha = 0;
		}
		
		var clipRegistro : MovieClip = Ranking.getClipRegistro(registro.getID());
		
		//Si aun no existe, lo carga:
		if (clipRegistro == null)
		{
			trace("Era null y se pone en " + registro.getID());
			clipRegistro = movieClip.attachMovie("ClipRegistro", "clipRegistro_" + registro.getID(), movieClip.getNextHighestDepth());
			Ranking.setClipRegistro(clipRegistro, registro.getID());
		}
		
		//Define el texto del clip del registro:
		clipRegistro.texto.text = Ranking.registros[posicion].toString();
		
		//Posiciona correctamente el clip del registro:
		var left : Number = Ranking.getRankingLeft();
		var top : Number = (Ranking.getEspacioEntreRegistros() + margenRegistro) * (posicion + 1);
		clipRegistro._x = left;
		clipRegistro._y = top;

		//trace("*** Top para id " + registro.getID() + " -> " + top);
		
		//Modifica la dimension del clip del registro:
		clipRegistro._width = Ranking.getAnchoRegistro();
		clipRegistro._height = Ranking.getAltoRegistro();

		//Se restaura el alpha, por si acaso:
		//clipRegistro._alpha = 100;
		//clipRegistro.texto._alpha = 0;
		
		//Crea la animacion:
		Ranking.alphaAparecer[posicion] = 0;
		Ranking.intervalAparecer[posicion] = setInterval(function()
  											 {
											 	var alpha : Number = Ranking.alphaAparecer[posicion]++;
												clipRegistro._alpha = alpha;
												if (alpha >= 100) { clearInterval(Ranking.intervalAparecer[posicion]); }
												//if (Ranking.registros[posicion].getID() == 12) { trace("alpha: " + alpha); }
											 }
											 , 25, posicion, clipRegistro);
		
		//Ranking.representarRanking(); //ATENCION: HACER ESTO SOLO DESPUES DE LA ANIMACION!!! (prueba).
	}
	
	//Reproduce la animacion de mover un una posicion en el ranking a un lugar consecutivo (realiza un "deslizamiento"):
	static function representarAnimacionDeslizar(registro : Registro, posicionAnterior : Number, posicionPosterior : Number) : Void
	{
		trace("* Animacion de deslizando registro de la posicion " + posicionAnterior + " a la posicion " + posicionPosterior);
		
		var movieClip : MovieClip = Ranking.getMovieClip();
		if (movieClip == null) { return; }
		
		var margenRegistro : Number = Ranking.getMargenRegistro();
		
		var clipRegistro : MovieClip = Ranking.getClipRegistro(registro.getID());
		
		//Si aun no existe, lo carga:
		if (clipRegistro == null)
		{
			clipRegistro = movieClip.attachMovie("ClipRegistro", "clipRegistro_" + registro.getID(), movieClip.getNextHighestDepth());
			Ranking.setClipRegistro(clipRegistro, registro.getID());
		}
		
		//Define el texto del clip del registro:
		clipRegistro.texto.text = Ranking.registros[posicionAnterior].toString();
		
		//Posiciona correctamente el clip del registro:
		var left : Number = Ranking.getRankingLeft();
		var top : Number = (Ranking.getEspacioEntreRegistros() + margenRegistro) * (posicionAnterior + 1);
		clipRegistro._x = left;
		clipRegistro._y = top;

		//Modifica la dimension del clip del registro:
		clipRegistro._width = Ranking.getAnchoRegistro();
		clipRegistro._height = Ranking.getAltoRegistro();

		//Se restaura el alpha, por si acaso:
		//clipRegistro._alpha = 100;
		//clipRegistro.texto._alpha = 0;
		
		//Crea la animacion:
		Ranking.altoDeslizar[posicionAnterior] = top;
		Ranking.anchoDeslizar[posicionAnterior] = Ranking.getAnchoRegistro();
		Ranking.intervalDeslizar[posicionAnterior] = setInterval(function()
  											 		 {
														var margenRegistro : Number = Ranking.getMargenRegistro();
														var alto : Number = Ranking.altoDeslizar[posicionAnterior];
														var altoDestino = (Ranking.getEspacioEntreRegistros() + margenRegistro) * (posicionPosterior + 1);
														
														var ancho : Number = Ranking.anchoDeslizar[posicionAnterior];
														
														if (Math.abs(alto - altoDestino) >= Math.abs(top - altoDestino) / 2) { Ranking.anchoDeslizar[posicionAnterior]--; }
														else { Ranking.anchoDeslizar[posicionAnterior]++; }
		
														if (posicionAnterior < posicionPosterior) { Ranking.altoDeslizar[posicionAnterior]++; }
														else { Ranking.altoDeslizar[posicionAnterior]--; }
														
														clipRegistro._y = alto;
														clipRegistro._width = ancho;
														
														if (posicionAnterior < posicionPosterior && alto >= altoDestino) { clearInterval(Ranking.intervalDeslizar[posicionAnterior]); clipRegistro._width = Ranking.getAnchoRegistro(); }
														else if (posicionAnterior > posicionPosterior && alto <= altoDestino) { clearInterval(Ranking.intervalDeslizar[posicionAnterior]); clipRegistro._width = Ranking.getAnchoRegistro(); }
														
														//trace("*** Alto: " + alto + ", Ancho: " + ancho + ", Alto destino: " + altoDestino);
													  }
													  , 25, posicionAnterior, posicionPosterior, clipRegistro, top);
		
		//Ranking.representarRanking(); //ATENCION: HACER ESTO SOLO DESPUES DE LA ANIMACION!!! (prueba).
	}
	
	//Reproduce la animacion de mover una posicion en el ranking a un lugar no consecutivo (realiza un "salto"):
	static function representarAnimacionIntercambiar(registro : Registro, posicionAnterior : Number, posicionPosterior : Number) : Void
	{
		trace("* Animacion de intercambiando registro de la posicion " + posicionAnterior + " a la posicion " + posicionPosterior);
		
		Ranking.representarRanking(); //ATENCION: HACER ESTO SOLO DESPUES DE LA ANIMACION!!! (prueba).
	}
	
	//Representa visualmente todo el ranking:
	static function representarRanking() : Void
	{
		var movieClip : MovieClip = Ranking.getMovieClip();
		if (movieClip == null) { return; }
		
		var margenRegistro : Number = Ranking.getMargenRegistro();
		
		//Recorre todos los registros:
		var clipRegistro : MovieClip = null;
		var left : Number = Ranking.getRankingLeft();
		var top : Number = 0;
		var registro : Registro = null;
		for (var x = 0; x < Ranking.getNumeroRegistros(); x++)
		{
			registro = Ranking.getRegistro(x);
			clipRegistro = Ranking.getClipRegistro(registro.getID());

			//Si aun no existe, lo carga:
			if (clipRegistro == null)
			{
				clipRegistro = movieClip.attachMovie("ClipRegistro", "clipRegistro_" + registro.getID(), movieClip.getNextHighestDepth());
				Ranking.setClipRegistro(clipRegistro, registro.getID());
			}
			
			//Define el texto del clip del registro:
			clipRegistro.texto.text = Ranking.registros[x].toString();
			
			//Posiciona correctamente el clip del registro:
			clipRegistro._x = left;
			clipRegistro._y = top;
			
			//trace("*** Top para id " + registro.getID() + " -> " + top);
			
			//trace("Registro #"+x+" imprimido en top: " + top); //Debug.
			top += Ranking.getEspacioEntreRegistros() + margenRegistro;
			
			//Modifica la dimension del clip del registro:
			//clipRegistro._width = (Ranking.registros[x].toString().length * clipRegistro.texto.size * 2) + margenRegistro;
			clipRegistro._width = Ranking.getAnchoRegistro();
			clipRegistro._height = Ranking.getAltoRegistro();
			
			//Se restaura el alpha, por si acaso:
			//clipRegistro._alpha = 100;
			//clipRegistro.texto._alpha = 0;
		}
		
		//Redimensiona el MovieClip principal:
		//movieClip._width = left + anchoMaximoClipRegistro + margenVentana;
		//movieClip.height = top + margenVentana;
	}
}