
;;  -------------------------------------------------------------------
;;  NOM:        Pantalla.asm
;;  DESCRIPCIO: fitxer en "ASM" amb subrutines d'acces a pantalla en
;;              mode text 80x25.
;;	ALUMNES:	Juan Alba Maldonado, Joaquim Aymemi Casanovas
;;  -------------------------------------------------------------------



PUBLIC _IniPantalla, _EscriureCar, _EsborraPantalla, _CapRectangle, _PintaRectangle, _PintaQuadrat, _PintaCreu, _EscriuString
PUBLIC _QuinCarAtr


_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS


_BSS    SEGMENT WORD PUBLIC 'BSS'

        SegmentPant DW ?        ; Variable que contindra el segment de
                                ; memoria on esta mapejada la pantalla
_BSS    ENDS


DGROUP  GROUP   _DATA, _BSS


ASSUME cs:PANTALLA_CODI, ds:DGROUP


PANTALLA_CODI SEGMENT BYTE PUBLIC 'CODE'

;;  *******************************************************************
;;    ADR IniPantalla (void);
;;
;;          Subrutina d'inicialitzacio:
;;              esbrina a quina adrea de memoria es troba mapejada la
;;              pantalla, retornant aquest valor com a resultat i tambe
;;              guardant una copia del valor del segment a una variable
;;              que s'utilitza a la resta de subrutines del modul.
;;              En cas que el sistema no estigui en mode text 80x25, es
;;              retorna el valor especial 0000:0000 (codi d'error).
;;  *******************************************************************

_IniPantalla    PROC FAR
        push    es

        mov     ax, 0
        mov     es, ax                  ; acces al segment 0000
        mov     al, es:[0449h]          ; AL <- Mode Video Actiu
        cmp     al, 7
        je      ModeMonocrom
        cmp     al, 2
        je      ModeColor
        cmp     al, 3
        je      ModeColor

	ModeErroni:
        mov     dx, 0
        jmp     Sortida

	ModeColor:
        mov     dx, 0B800h
        jmp     Sortida

	ModeMonocrom:
        mov     dx, 0B000h

	Sortida:
		mov     SegmentPant, dx
        mov     ax, 0

        pop     es
        ret
_IniPantalla    ENDP



;;  *******************************************************************
;;    void EscriureCar (BYTE fila, BYTE columna, char caracter, BYTE atribut);
;;
;;          Subrutina d'escriptura d'un caracter per pantalla:
;;              escriu a pantalla el caracter que se li passa, amb l'atri-
;;              but indicat, a les coordenades especificades. La informacio
;;              d'on es troba mapejada la pantalla, l'obte de SegmentPant.
;;  *******************************************************************

_EscriureCar    PROC FAR
        push    bp
        mov     bp, sp
        push    ax
        push    bx
        push    es

		; Calcul del desplaament respecte a l'inici de pantalla
        mov     al, [bp+6]      ; AL <- fila
        mov     bl, 80
        mul     bl              ; AX <- fila*80
        mov     bl, [bp+8]      ; BL <- columna
        mov     bh, 0           ; BX <- columna
        add     bx, ax          ; BX <- fila*80+columna
        shl     bx, 1           ; BX <- (fila*80+columna)*2
        mov     es, SegmentPant

            ; Escriptura del caracter
        mov     al, [bp+10]     ; AL <- caracter
        mov     ah, [bp+12]     ; AH <- atribut
        mov     es:[bx], ax     ; Accs a memria de video

        pop     es
        pop     bx
        pop     ax
        pop     bp

        ret
_EscriureCar    ENDP


;; *************************************************
;; Aqu s'ubicaran les noves subrutines de pantalla 
;;**************************************************

_QuinCarAtr PROC FAR	
	;bp
	;ip
	;cs
	;fil bp + 6
	;col bp + 8
	
	push bp
	mov bp,sp
	
	;es retorna el resultat per ax
	push bx
	push cx
	push dx
	push es

	mov al,[bp+6]
	mov bl,[bp+8]
	cmp byte ptr al,0
	jb QuinCarAtr_error
	cmp byte ptr al,25	
	jae QuinCarAtr_error
	cmp byte ptr bl,0
	jb QuinCarAtr_error
	cmp byte ptr bl,80
	jae QuinCarAtr_error
	
	mov ah,0
	mov bh,80
	mul bh
	mov bh,0
	add bx,ax
	shl bx,1
	
	mov es,SegmentPant
	mov ax,es:[bx]
	;mov es:[1492],ax ;prova
	
	jmp QuinCarAtr_correcte
	
	QuinCarAtr_error:
	mov ax,0
	
	QuinCarAtr_correcte:
	
	pop es
	pop dx
	pop cx
	pop bx
	pop bp
	ret
_QuinCarAtr ENDP


_EscriuString PROC FAR
	;bp
	;ip			bp + 2
	;cs			bp + 4
	;fil		bp + 6
	;col		bp + 8
	;off_cadena	bp + 10
	;seg_cadena	bp + 12
	;atribut	bp + 14
	
	push bp
	mov bp,sp
	
	push ax
	push bx
	push cx
	push dx
	push si
	push es
		
	;comprova posicio inicial
	cmp byte ptr[bp+6],0 ;fil>=0
	jb EString_fora
	cmp byte ptr[bp+6],25;fil<25
	jae EString_fora
	cmp byte ptr[bp+8],0 ;col>=0
	jb EString_fora
	cmp byte ptr[bp+8],80;col<80
	jae EString_fora
		
	;conta caracters	
	mov es,[bp+12]	;es = segment cadena
	mov si,[bp+10]	;si = offset cadena	
	mov bl,0
	
	EString_mentre:
		mov ax,es:[si]
		cmp al, byte ptr 0
		je EString_fmentre
		inc si
		inc bl
		jmp EString_mentre
	EString_fmentre:
		

	
	mov bh,0
	mov dx,bx ;dx = n_caract
	add bl,byte ptr[bp+8]
	cmp bl, byte ptr 80
	jae EString_fora
	
	;Calcul desplaament inicial
	mov ah,0
	mov al,[bp+6]
	mov bh,0
	mov bl,80
	mul bl
	mov bh,0
	mov bl,[bp+8]
	add bx,ax
	shl bx,1
	;bx = despl
	
	mov	si,[bp+10]
	mov ah,[bp+14] ;ah = atribut
	mov cx,0

	EString_mentre2:
	mov es,[bp+12]
	mov cx, es:[si]
	cmp byte ptr cl,0	
	je EString_fmentre2
			
		mov al,es:[si]
		mov es,SegmentPant
		mov es:[bx],ax
		inc si
		add bx,2
		jmp EString_mentre2
	EString_fmentre2:
	
	EString_fora:
	
	pop es
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	pop bp
	ret	
_EscriuString ENDP


_EsborraPantalla PROC FAR ;binari asci32: 0010 0000 	
	push bp
	mov bp,sp

	; Aprovechamos la funcion _PintaRectangle:
	push [bp+6]	; atrib
	push 25		; alto (= 25)
	push 80		; ancho (= 80)
	push 0		; columna (= 0)
	push 0		; fila ( = 0)
	call FAR PTR _PintaRectangle
	add sp, 10
	
	pop bp	

	ret	
_EsborraPantalla ENDP


; BOOL CapRectangle (BYTE fil, BYTE col, BYTE ancho, BYTE alto)
_CapRectangle PROC FAR
	;bp
	;ip 	bp+2
	;cs 	bp+4
	;fil 	bp+6
	;col 	bp+8
	;ancho 	bp+10
	;alto 	bp+12

	push bp
	mov bp, sp

	; Guarda los registros que se utilizan:
	push bx
	;push ax

	; Si el area del rectangulo no queda dentro de pantalla:
	mov bx, 0	; Si se queda en 0, indica que no se puede pintar nada.
	; if (fila < 0 || fila >= 25 || fila+alto < 1 || fila+alto > 25) { return; }
	mov ax, [bp+6]
	cmp ax, 0
	jb finCapRectangle
	cmp ax, 25
	jge finCapRectangle
	add  al, [bp+12]
	cmp al, 1
	jb finCapRectangle
	cmp al, 25
	ja finCapRectangle
	; if (columna < 0 || columna >= 80 || columna+ancho < 1 || fila+ancho > 80) { return; }
	mov ax, [bp+8]
	cmp ax, 0
	jb finCapRectangle
	cmp ax, 80
	jge finCapRectangle
	add  al, [bp+10]
	cmp al, 0
	jb finCapRectangle
	cmp al, 80
	ja finCapRectangle

	mov bx, 1	; Indica que se puede pintar.

	finCapRectangle:

	; Salida (1 = se puede pintar, 0 = no se puede pintar):
	mov ax, bx

	pop bx
	pop bp
	ret
_CapRectangle ENDP


; void PintaRectangle (BYTE fil, BYTE col, BYTE ancho, BYTE alto, BYTE atrib)
_PintaRectangle PROC FAR
	;bp
	;ip 	bp+2
	;cs 	bp+4
	;fil 	bp+6
	;col 	bp+8
	;ancho 	bp+10
	;alto 	bp+12
	;atrib 	bp+14

	push bp
	mov bp, sp

	; Guarda los registros que se utilizan:
	push cx
	push ax
	push dx
	push bx

	; Si el area del rectangulo no queda dentro de pantalla, no hace nada:
	push [bp+12]	; alto
	push [bp+10]	; ancho
	push [bp+8]		; columna
	push [bp+6]		; fila
	call FAR PTR _CapRectangle
	add sp, 8
	cmp ax, 0
	je finPintaRectangle

	; Bucle de fila a fila+alto:
	mov cx, [bp+6]
	mov ax, [bp+6]
	add  al, [bp+12]
	bucleFila:
	cmp cx, ax
	jge finBucleFila
		; Bucle de columna a columna+ancho: 	
		mov dx, [bp+8]
		mov bx, [bp+8]
		add bl, [bp+10]
		bucleColumna:
		cmp dx, bx
		jge finBucleColumna
			; Llama a _EscriureCar:
			push [bp+14]		; atrib
			push 32				; caracter
			push dx				; colmna
			push cx				; fila
			call FAR PTR _EscriureCar
			add sp, 8
		inc dx
		jmp bucleColumna
		finBucleColumna:
	inc cx
	jmp bucleFila
	finBucleFila:

	finPintaRectangle:

	; Restaura los registros utilizados:
	pop bx
	pop dx
	pop ax
	pop cx

	pop bp
	ret
_PintaRectangle ENDP


_PintaQuadrat PROC FAR
	;bp
	;ip 	bp+2
	;cs 	bp+4
	;fil 	bp+6
	;col 	bp+8
	;mida 	bp+10
	;atrib 	bp+12
	
	push bp
	mov bp, sp
		
	; Aprovechamos la funcion _PintaRectangle:
	push [bp+12]	; atrib
	push [bp+10]	; alto (= mida)
	push [bp+10]	; ancho (= mida)
	push [bp+8]		; columna
	push [bp+6]		; fila
	call FAR PTR _PintaRectangle
	add sp, 10

	pop bp
	
	ret
_PintaQuadrat ENDP


_PintaCreu PROC FAR	
	;tamany bp-2
	;bp
	;ip 	bp+2
	;cs 	bp+4
	;fil 	bp+6
	;col 	bp+8
	;mida 	bp+10
	;atrib 	bp+12
	
	push bp
	mov bp,sp

	push ax
	push bx

	; Si no cabe la cruz, no la dibuja:
	; ax = mida * 2 + 1
	mov ax, 2
	mul BYTE PTR [bp+10]
	inc ax
	push ax			; alto (mida * 2 + 1)
	push ax			; ancho (mida * 2 + 1)
	; bx = col - mida:
	mov bx, [bp+8]
	sub bx, [bp+10]
	push bx			; columna  (col-mida)
	; bx = fil - mida:
	mov bx, [bp+6]
	sub bx, [bp+10]
	push bx			; fila (fil-mida)
	call FAR PTR _CapRectangle
	add sp, 8
	cmp ax, 0
	je finPintaCreu

	; ax = mida * 2 + 1
	mov ax, 2
	mul BYTE PTR [bp+10]
	inc ax

	; Aprovechamos la funcion _PintaRectangle:
	; Rectangulo vertical:
	push [bp+12]	; atrib
	push ax			; alto (mida * 2 + 1)
	push 1			; ancho (1)
	push [bp+8]		; columna
	; bx = fil - mida:
	mov bx, [bp+6]
	sub bx, [bp+10]
	push bx			; fila (fil-mida)
	call FAR PTR _PintaRectangle
	add sp, 10

	; ax = mida * 2 + 1
	mov ax, 2
	mul BYTE PTR [bp+10]
	inc ax

	; Rectangulo horizontal:
	push [bp+12]	; atrib
	push 1			; alto (1)
	push ax			; ancho (mida * 2 + 1)
	; bx = col - mida:
	mov bx, [bp+8]
	sub bx, [bp+10]
	push bx			; columna (col-mida)
	push [bp+6]		; fila
	call FAR PTR _PintaRectangle
	add sp, 10

	finPintaCreu:

	; Restaura los registros utilizados:
	pop bx
	pop ax

	pop bp
	ret
_PintaCreu ENDP


PANTALLA_CODI ENDS

END
