/*  *******************************************************************
    NOM:        Pantalla.h
    CREAT PER:  P. Millan, coordinador EC I (2003/04)
    DATA:       01/ABR/2004
    DESCRIPCIO: Rutines d'acces a pantalla en mode text 80x25.
    ALUMNES:    Juan Alba Maldonado, Joaquim Aymemi Casanovas
    ******************************************************************* */

/* Per impedir multiples "inclusions" d'aquest fitxer capalera: */
#ifndef PANTALLA_H
#define PANTALLA_H

#include "tipus.h"    /* Definicions de tipus elementals: BYTE, WORD, ADR */

        /* Per a que funcioni tambe compilant en versio C++ */
#ifdef __cplusplus
extern "C" {
#endif



/***    Declaracio de FUNCIONS del modul                      ***/


extern ADR IniPantalla (void);

        /* esbrina a quina adrea de memoria es troba mapejada la
           pantalla, retornant aquest valor com a resultat i tambe
           guardant una copia del valor del segment a una variable
           que s'utilitza a la resta de subrutines del modul.
           En cas que el sistema no estigui en mode text 80x25, es
           retorna el valor especial 0000:0000 (codi d'error). */


extern void EscriureCar (BYTE fila, BYTE columna, char caracter, BYTE atribut);

        /* escriu a pantalla el caracter que se li passa, amb l'atri-
           but indicat, a les coordenades especificades. La informacio
           d'on es troba mapejada la pantalla, l'obte de SegmentPant. */


/*********************************************************************/
/*Aqu s'ubicaran les capaleres de les noves subrutines de pantalla */
/*********************************************************************/

extern void EsborraPantalla(BYTE atribut);
extern void CapRectangle(BYTE fil, BYTE col, BYTE amplada, BYTE altura);
extern void PintaRectangle(BYTE fil, BYTE col, BYTE amplada, BYTE altura, BYTE atr);
extern void PintaQuadrat(BYTE fil, BYTE col, BYTE mida, BYTE atr);
extern void PintaCreu(BYTE fil, BYTE col, BYTE mida, BYTE atr);
extern void EscriuString(BYTE fil, BYTE col, char * string, BYTE atr);
extern WORD QuinCarAtr(BYTE fil, BYTE col);

#ifdef __cplusplus
}
#endif


#endif
