
;;  -------------------------------------------------------------------
;;  NOM:        Tecl_Enq.asm
;;  CREAT PER:  P. Millan, coordinador EC I (2003/04)
;;  DATA:       08/ABR/2004
;;  DESCRIPCIO: fitxer en "ASM" amb subrutines d'acces a teclat amb
;;              sincronitzacio per ENQUESTA.
;;  ALUMNES:	Juan Alba Maldonado
;;				Joaquim Aymem Casanovas
;;  DATA:       29/ABR/2009
;;  DESCRIPCIO: afegides rutines de la practica 3 de EC-1
;;  -------------------------------------------------------------------


        ; CONTROLADOR D'INTERRUPCIONS:
KINT_IMR        EQU     21h     ; Registre de Mascares d'Interrupcio

        ; CONTROLADOR DE TECLAT (a partir del i286):
KTECL_DADES     EQU     60h     ; Registre de DADES del teclat
KTECL_CONTROL   EQU     61h     ; Registre de CONTROL del teclat
KTECL_ESTAT     EQU     64h     ; Registre d' ESTAT del teclat


T_ESC EQU     27      ; Codi ASCII de la Tecla <ESC>
T_DEL EQU      8      ; Codi ASCII de la Tecla <BACKSPACE/DELETE>
T_TAB EQU      9      ; Codi ASCII de la Tecla <TAB>
T_RET EQU     13      ; Codi ASCII de la Tecla <RETURN/ENTER>
T_ERR EQU      0      ; Indicacio de que no existeix traduccio ASCII


        ; SUBRUTINES PUBLIQUES D'AQUEST MODUL:
PUBLIC _IniTeclatENQ
PUBLIC _FiTeclatENQ
PUBLIC _LlegirTeclatENQ
PUBLIC _Scancode2ASCII



_DATA   SEGMENT WORD PUBLIC 'DATA'
  ; Taula de traduccio de scancode a ASCII (majuscules). [KEYB SP+WIN95]

ascii   DB      T_ESC,"1234567890'",T_DEL       ; 1-14
        DB      T_TAB,'QWERTYUIOP[]',T_RET,T_ERR ;15-29
        DB      'ASDFGHJKL{\',T_ERR             ;30-42
        DB      '}ZXCVBNM,.-',T_ERR,'*'          ;43-55
        DB      T_ERR,' ', 13 DUP (T_ERR)        ;56-70
        DB      '789-456+1230.',T_ERR,T_ERR,'<'  ;71-86
        DB      41 DUP (T_ERR)                   ;87-127

_DATA   ENDS


_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS


DGROUP  GROUP   _DATA, _BSS


ASSUME cs:TECLAT_ENQUESTA_CODI, ds:DGROUP


TECLAT_ENQUESTA_CODI SEGMENT BYTE PUBLIC 'CODE'

;;  *******************************************************************
;;    void IniTeclatENQ (void);
;;
;;          Subrutina d'inicialitzacio:
;;              desactiva (inhibeix) les interrupcions del teclat (IRQ1)
;;              accedint a l'IMR del controlador d'interrupcions, per
;;              tal de poder utilitzar el teclat per enquesta, amb la
;;              rutina _LlegirTeclatENQ.
;;              Cal cridar aquesta subrutina una vegada, abans de qual-
;;              sevol crida a _LlegirTeclatENQ.
;;  *******************************************************************

_IniTeclatENQ   PROC FAR
        push    ax            ; guardar registres que es modifiquen
        pushf                 ; guardar valor del flag d'interrupcio
        cli                   ; inhibir TOTES les interrupcions (emmascarables)

        in      al, KINT_IMR
        or      al, 00000010b ; desactivar IRQ1 (teclat)
        out     KINT_IMR, al  ; es a dir, posar a u el bit 1 del KINT_IMR

        popf                  ; recuperar valor del flag d'interrupcio (0 o 1)
        pop     ax            ; recuperar registres modificats
        ret
_IniTeclatENQ   ENDP



;;  *******************************************************************
;;    void FiTeclatENQ (void);
;;
;;          Subrutina de finalitzacio:
;;              activa (desinhibeix) les interrupcions del teclat (IRQ1)
;;              accedint a l'IMR del controlador d'interrupcions, per
;;              tal de deixar el teclat en el seu mode de funcionament
;;              normal (per interrupcions).
;;              Cal cridar aquesta rutina quan s'hagi acabat de treballar
;;              amb el teclat per enquesta i abans d'acabar el programa,
;;              doncs altrament el sistema operatiu no podra llegir el
;;              teclat (ho fa per interrupcions: "penjat").
;;  *******************************************************************

_FiTeclatENQ    PROC FAR
        push    ax            ; guardar registres que es modifiquen
        pushf                 ; guardar valor del flag d'interrupcio
        cli                   ; inhibir TOTES les interrupcions

        in      al, KINT_IMR
        and     al, 11111101b ; activar IRQ1 (teclat)
        out     KINT_IMR, al  ; es a dir, posar a zero el bit 1 del KINT_IMR

        popf                  ; recuperar valor del flag d'interrupcio
        pop     ax            ; recuperar registres modificats
        ret
_FiTeclatENQ    ENDP



;;  *******************************************************************
;;    BYTE LlegirTeclatENQ (void);
;;
;;          Subrutina de lectura d'una tecla per enquesta:
;;              llegeix el teclat per enquesta, esperant que es premi
;;              una tecla. Nomes "fa cas" quan la tecla pugi ("break")
;;              i no quan baixi ("make"). El codi retornat es el codi
;;              de rastreig (scancode).
;;  *******************************************************************

_LlegirTeclatENQ PROC FAR

Enq_tec:

	Llegir_Enq:
	
	in al, KTECL_ESTAT		;Llegir registre d'estat del KTeclat
	test al, 00000001b		;testejar el bit 0
	jz Llegir_Enq			;si reg_Estat[0]== 0 torna a llegir
    in al, KTECL_DADES 		; instruccio per llegir el registre de dades
                            ; del KTeclat (sobre el registre AL)

	test al, 10000000b		;si reg_Dades[7] == 0 torna a llegir
    jz Llegir_Enq	                         
	and al,01111111b		;es posa el al[7]=0 per pasar nomes el scancode i no el bit de control							 
    ret
	
_LlegirTeclatENQ ENDP



;;  *******************************************************************
;;    char Scancode2ASCII (BYTE scancode);
;;
;;          Subrutina de conversio de scancode a ASCII:
;;              tradueix a ASCII el codi de rastreig (scancode) que se
;;              li passa. En cas de no tenir traduccio, retorna el va-
;;              lor 0 (per accedir a la taula de traduccio es pot uti-
;;              litzar la instruccio XLAT d'acces a taules de bytes).
;;  *******************************************************************

_Scancode2ASCII PROC FAR
     push    bp
     mov     bp, sp
     push    bx

     mov     bx, OFFSET ascii  ; Desplaament de la taula de traduccio
     mov     al, [bp+6]        ; AL <- scancode a traduir

     and     al, 01111111b     ; Neteja el bit de Make/Break
     dec     al                ; El scancode 1 esta a la posicio 0
     xlat                      ; AL <- DS:[BX+AL] ==> AL <- codi ASCII

     pop     bx
     pop     bp
     ret
_Scancode2ASCII ENDP



TECLAT_ENQUESTA_CODI ENDS

        END
