
/*  *******************************************************************
    NOM:        TECL_ENQ.H
    CREAT PER:  P. Millan, coordinador EC I (2002/03)
    DATA:       09/MAI/2003
    DESCRIPCIO: Rutines d'acces a teclat amb sincronitzacio per enquesta.
    ALUMNES:    Juan Alba Maldonado, Joaquim Aymemi Casanovas
    ******************************************************************* */



        /* Per impedir multiples "inclusions" d'aquest fitxer */
#ifndef TECL_ENQ_H
#define TECL_ENQ_H

#include "tipus.h"    /* Definicions de tipus elementals: BYTE, WORD, ADR */

        /* Per a que funcioni tambe compilant en versio C++ */
#ifdef __cplusplus
extern "C" {
#endif



/***    Declaracio de FUNCIONS del modul                      ***/


extern void IniTeclatENQ (void);

        /*    desactiva (inhibeix) les interrupcions del teclat (IRQ1)
              accedint a l'IMR del controlador d'interrupcions, per
              tal de poder utilitzar el teclat per enquesta, amb la
              rutina _LlegirTeclatENQ.
              Cal cridar aquesta subrutina una vegada, abans de qual-
              sevol crida a _LlegirTeclatENQ. */


extern void FiTeclatENQ (void);

        /*    activa (desinhibeix) les interrupcions del teclat (IRQ1)
              accedint a l'IMR del controlador d'interrupcions, per
              tal de deixar el teclat en el seu mode de funcionament
              normal (per interrupcions).
              Cal cridar aquesta rutina quan s'hagi acabat de treballar
              amb el teclat per enquesta i abans d'acabar el programa,
              doncs altrament el sistema operatiu no podra llegir el
              teclat (ho fa per interrupcions: "penjat"). */


extern BYTE LlegirTeclatENQ (void);

        /*    llegeix el teclat per enquesta, esperant que es premi
              una tecla. Nomes "fa cas" quan la tecla baixi ("make")
              i no quan pugi ("break"). El codi retornat es el codi
              de rastreig (scancode). */



extern char Scancode2ASCII (BYTE scancode);

        /*    tradueix a ASCII el codi de rastreig (scancode) que se
              li passa. En cas de no tenir traduccio, retorna el va-
              lor 0 (per accedir a la taula de traduccio es pot uti-
              litzar la instruccio XLAT d'acces a taules de bytes). */



#ifdef __cplusplus
}
#endif


#endif
